/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code;

import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;

public class SwitchInstruction
extends Instruction {
    private int[] destinations;
    private int[] values;
    private int defaultdest;

    @Override
    public void initInstruction(InstructionSequence seq) {
        int pref = this.opcode == 170 ? 3 : 2;
        int len = this.getOperands().length - pref;
        this.defaultdest = seq.getPointerByRelOffset(this.getOperand(0));
        int low = 0;
        if (this.opcode == 171) {
            len /= 2;
        } else {
            low = this.getOperand(1);
        }
        this.destinations = new int[len];
        this.values = new int[len];
        int i = 0;
        int k = 0;
        while (i < len) {
            if (this.opcode == 171) {
                this.values[i] = this.getOperand(pref + k);
                ++k;
            } else {
                this.values[i] = low + k;
            }
            this.destinations[i] = seq.getPointerByRelOffset(this.getOperand(pref + k));
            ++i;
            ++k;
        }
    }

    @Override
    public SwitchInstruction clone() {
        SwitchInstruction newinstr = (SwitchInstruction)super.clone();
        newinstr.defaultdest = this.defaultdest;
        newinstr.destinations = (int[])this.destinations.clone();
        newinstr.values = (int[])this.values.clone();
        return newinstr;
    }

    public int[] getDestinations() {
        return this.destinations;
    }

    public void setDestinations(int[] destinations) {
        this.destinations = destinations;
    }

    public int getDefaultdest() {
        return this.defaultdest;
    }

    public void setDefaultdest(int defaultdest) {
        this.defaultdest = defaultdest;
    }

    public int[] getValues() {
        return this.values;
    }

    public void setValues(int[] values) {
        this.values = values;
    }
}

