/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.jetbrains.annotations.NotNull;

public class TemporaryPlacesInjector
implements MultiHostInjector {
    public static final Logger LOG = Logger.getInstance((String)"org.intellij.plugins.intelliLang.inject.TemporaryPlacesInjector");
    private final TemporaryPlacesRegistry myRegistry;

    public TemporaryPlacesInjector(TemporaryPlacesRegistry registry) {
        this.myRegistry = registry;
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<PsiLanguageInjectionHost>> list = Collections.singletonList(PsiLanguageInjectionHost.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/TemporaryPlacesInjector", "elementsToInjectIn"));
        }
        return list;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        Language language;
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/intellij/plugins/intelliLang/inject/TemporaryPlacesInjector", "getLanguagesToInject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/intellij/plugins/intelliLang/inject/TemporaryPlacesInjector", "getLanguagesToInject"));
        }
        if (!(context instanceof PsiLanguageInjectionHost) || !((PsiLanguageInjectionHost)context).isValidHost()) {
            return;
        }
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)context;
        PsiFile containingFile = context.getContainingFile();
        InjectedLanguage injectedLanguage = this.myRegistry.getLanguageFor(host, containingFile);
        Language language2 = language = injectedLanguage != null ? injectedLanguage.getLanguage() : null;
        if (language == null) {
            return;
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)host);
        if (manipulator == null) {
            return;
        }
        List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> trinities = Collections.singletonList(Trinity.create((Object)host, (Object)injectedLanguage, (Object)manipulator.getRangeInElement((PsiElement)host)));
        InjectorUtils.registerInjection(language, trinities, containingFile, registrar);
        InjectorUtils.registerSupport(this.myRegistry.getLanguageInjectionSupport(), false, registrar);
    }
}

