/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.GithubShowCommitInBrowserAction;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubShowCommitInBrowserFromHistoryAction
extends GithubShowCommitInBrowserAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/github/GithubShowCommitInBrowserFromHistoryAction", "update"));
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        VcsFileRevision fileRevision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        if (project == null || filePath == null || fileRevision == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForFile(filePath);
        boolean isOnGithub = repository != null && GithubUtil.isRepositoryOnGitHub(repository);
        e.getPresentation().setEnabledAndVisible(isOnGithub && fileRevision instanceof GitFileRevision);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/github/GithubShowCommitInBrowserFromHistoryAction", "actionPerformed"));
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        FilePath filePath = (FilePath)e.getRequiredData(VcsDataKeys.FILE_PATH);
        VcsFileRevision fileRevision = (VcsFileRevision)e.getRequiredData(VcsDataKeys.VCS_FILE_REVISION);
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForFile(filePath);
        GithubShowCommitInBrowserFromHistoryAction.openInBrowser(project, repository, ((GitRevisionNumber)fileRevision.getRevisionNumber()).getRev());
    }
}

