/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.DataConstructor;
import org.jetbrains.plugins.github.api.GithubGist;
import org.jetbrains.plugins.github.api.GithubUser;
import org.jetbrains.plugins.github.api.GithubUserRaw;

class GithubGistRaw
implements DataConstructor {
    @Nullable
    public String id;
    @Nullable
    public String description;
    @SerializedName(value="public")
    @Nullable
    public Boolean isPublic;
    @Nullable
    public String url;
    @Nullable
    public String htmlUrl;
    @Nullable
    public String gitPullUrl;
    @Nullable
    public String gitPushUrl;
    @Nullable
    public Map<String, GistFileRaw> files;
    @Nullable
    public GithubUserRaw owner;
    @Nullable
    public Date createdAt;

    GithubGistRaw() {
    }

    @NotNull
    public GithubGist createGist() {
        GithubUser user = this.owner == null ? null : this.owner.createUser();
        ArrayList<GithubGist.GistFile> files = new ArrayList<GithubGist.GistFile>();
        for (Map.Entry<String, GistFileRaw> entry : this.files.entrySet()) {
            files.add(entry.getValue().create());
        }
        GithubGist githubGist = new GithubGist(this.id, this.description, this.isPublic, this.htmlUrl, files, user);
        if (githubGist == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubGistRaw", "createGist"));
        }
        return githubGist;
    }

    @Override
    @NotNull
    public <T> T create(@NotNull Class<T> resultClass) {
        if (resultClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultClass", "org/jetbrains/plugins/github/api/GithubGistRaw", "create"));
        }
        if (resultClass == GithubGist.class) {
            GithubGist githubGist = this.createGist();
            if (githubGist == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubGistRaw", "create"));
            }
            return (T)githubGist;
        }
        throw new ClassCastException(this.getClass().getName() + ": bad class type: " + resultClass.getName());
    }

    public static class GistFileRaw {
        @Nullable
        public Long size;
        @Nullable
        public String filename;
        @Nullable
        public String content;
        @Nullable
        public String raw_url;
        @Nullable
        public String type;
        @Nullable
        public String language;

        @NotNull
        public GithubGist.GistFile create() {
            GithubGist.GistFile gistFile = new GithubGist.GistFile(this.filename, this.content, this.raw_url);
            if (gistFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubGistRaw$GistFileRaw", "create"));
            }
            return gistFile;
        }
    }
}

