/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.DataConstructor;
import org.jetbrains.plugins.github.api.GithubPullRequest;
import org.jetbrains.plugins.github.api.GithubRepoRaw;
import org.jetbrains.plugins.github.api.GithubUserRaw;

class GithubPullRequestRaw
implements DataConstructor {
    @Nullable
    public Long number;
    @Nullable
    public String state;
    @Nullable
    public String title;
    @Nullable
    public String body;
    @Nullable
    public String bodyHtml;
    @Nullable
    public String url;
    @Nullable
    public String htmlUrl;
    @Nullable
    public String diffUrl;
    @Nullable
    public String patchUrl;
    @Nullable
    public String issueUrl;
    @Nullable
    public Boolean merged;
    @Nullable
    public Boolean mergeable;
    @Nullable
    public Integer comments;
    @Nullable
    public Integer commits;
    @Nullable
    public Integer additions;
    @Nullable
    public Integer deletions;
    @Nullable
    public Integer changedFiles;
    @Nullable
    public Date createdAt;
    @Nullable
    public Date updatedAt;
    @Nullable
    public Date closedAt;
    @Nullable
    public Date mergedAt;
    @Nullable
    public GithubUserRaw user;
    @Nullable
    public LinkRaw head;
    @Nullable
    public LinkRaw base;

    GithubPullRequestRaw() {
    }

    @NotNull
    public GithubPullRequest createPullRequest() {
        GithubPullRequest githubPullRequest = new GithubPullRequest(this.number, this.state, this.title, this.bodyHtml, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.createdAt, this.updatedAt, this.closedAt, this.mergedAt, this.user.createUser(), this.head.create(), this.base.create());
        if (githubPullRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubPullRequestRaw", "createPullRequest"));
        }
        return githubPullRequest;
    }

    @Override
    @NotNull
    public <T> T create(@NotNull Class<T> resultClass) {
        if (resultClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultClass", "org/jetbrains/plugins/github/api/GithubPullRequestRaw", "create"));
        }
        if (resultClass == GithubPullRequest.class) {
            GithubPullRequest githubPullRequest = this.createPullRequest();
            if (githubPullRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubPullRequestRaw", "create"));
            }
            return (T)githubPullRequest;
        }
        throw new ClassCastException(this.getClass().getName() + ": bad class type: " + resultClass.getName());
    }

    public static class LinkRaw {
        @Nullable
        public String label;
        @Nullable
        public String ref;
        @Nullable
        public String sha;
        @Nullable
        public GithubRepoRaw repo;
        @Nullable
        public GithubUserRaw user;

        @NotNull
        public GithubPullRequest.Link create() {
            GithubPullRequest.Link link = new GithubPullRequest.Link(this.label, this.ref, this.sha, this.repo.createRepo(), this.user.createUser());
            if (link == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubPullRequestRaw$LinkRaw", "create"));
            }
            return link;
        }
    }
}

