/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.RefResolveService;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.List;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxScopeEnlarger;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;
import org.jetbrains.plugins.javaFX.indexing.JavaFxIdsIndex;

public class JavaFxImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(PsiElement element) {
        if (element instanceof PsiMethod) {
            return this.isImplicitMethodUsage((PsiMethod)element);
        }
        return this.isImplicitWrite(element);
    }

    public boolean isImplicitMethodUsage(PsiMethod method) {
        if (!JavaFxImplicitUsageProvider.isImplicitFxmlAccess((PsiModifierListOwner)method)) {
            return false;
        }
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)method.getProject());
        JavaFxScopeEnlarger.GlobalFxmlSearchScope fxmlScope = new JavaFxScopeEnlarger.GlobalFxmlSearchScope(projectScope);
        return JavaFxImplicitUsageProvider.isFxmlUsage((PsiMember)method, (GlobalSearchScope)fxmlScope);
    }

    private static boolean isFxmlUsage(PsiMember member, GlobalSearchScope scope) {
        PsiSearchHelper.SearchCostResult searchCost;
        String name = member.getName();
        if (name == null) {
            return false;
        }
        Project project = member.getProject();
        PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance((Project)project);
        PsiSearchHelper.SearchCostResult searchCostResult = searchCost = RefResolveService.getInstance((Project)project).isUpToDate() ? PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES : searchHelper.isCheapEnoughToSearch(name, scope, null, null);
        if (searchCost == PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES) {
            Query query = ReferencesSearch.search((PsiElement)member, (SearchScope)scope);
            return query.findFirst() != null;
        }
        return false;
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            if (!JavaFxImplicitUsageProvider.isImplicitFxmlAccess((PsiModifierListOwner)field)) {
                return false;
            }
            String fieldName = field.getName();
            if (fieldName == null) {
                return false;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if (qualifiedName == null) {
                return false;
            }
            Project project = element.getProject();
            Collection<VirtualFile> containingFiles = JavaFxIdsIndex.getContainingFiles(project, fieldName);
            if (containingFiles.isEmpty()) {
                return false;
            }
            List<VirtualFile> fxmls = JavaFxControllerClassIndex.findFxmlsWithController(project, qualifiedName);
            for (VirtualFile fxml : fxmls) {
                if (!containingFiles.contains(fxml)) continue;
                return true;
            }
            return JavaFxImplicitUsageProvider.isFxmlUsage((PsiMember)field, GlobalSearchScope.filesScope((Project)project, containingFiles));
        }
        return false;
    }

    private static boolean isImplicitFxmlAccess(PsiModifierListOwner member) {
        return !member.hasModifierProperty("public") && AnnotationUtil.isAnnotated((PsiModifierListOwner)member, (String)"javafx.fxml.FXML", (boolean)false);
    }
}

