/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.packaging;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.packaging.JavaFxApplicationIcons;
import org.jetbrains.plugins.javaFX.packaging.JavaFxArtifactPropertiesEditor;

public class JavaFxApplicationIconsDialog
extends DialogWrapper {
    private Panel myPanel;
    private final Project myProject;

    public JavaFxApplicationIconsDialog(JComponent parent, JavaFxApplicationIcons icons, Project project) {
        super((Component)parent, true);
        this.myProject = project;
        this.setTitle("Choose Application Icons");
        this.init();
        if (icons != null) {
            JavaFxArtifactPropertiesEditor.setSystemDependentPath(this.myPanel.myLinuxIconPath, icons.getLinuxIcon());
            JavaFxArtifactPropertiesEditor.setSystemDependentPath(this.myPanel.myMacIconPath, icons.getMacIcon());
            JavaFxArtifactPropertiesEditor.setSystemDependentPath(this.myPanel.myWindowsIconPath, icons.getWindowsIcon());
        }
        JavaFxApplicationIconsDialog.addBrowseListener(this.myPanel.myLinuxIconPath, "png", project);
        JavaFxApplicationIconsDialog.addBrowseListener(this.myPanel.myMacIconPath, "icns", project);
        JavaFxApplicationIconsDialog.addBrowseListener(this.myPanel.myWindowsIconPath, "ico", project);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myPanel = new Panel();
        return this.myPanel.myWholePanel;
    }

    protected void doOKAction() {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        if (!this.isValidPath(this.myPanel.myLinuxIconPath, index, "Linux")) {
            return;
        }
        if (!this.isValidPath(this.myPanel.myMacIconPath, index, "Mac")) {
            return;
        }
        if (!this.isValidPath(this.myPanel.myWindowsIconPath, index, "Windows")) {
            return;
        }
        super.doOKAction();
    }

    @NotNull
    public JavaFxApplicationIcons getIcons() {
        JavaFxApplicationIcons icons = new JavaFxApplicationIcons();
        icons.setLinuxIcon(JavaFxArtifactPropertiesEditor.getSystemIndependentPath(this.myPanel.myLinuxIconPath));
        icons.setMacIcon(JavaFxArtifactPropertiesEditor.getSystemIndependentPath(this.myPanel.myMacIconPath));
        icons.setWindowsIcon(JavaFxArtifactPropertiesEditor.getSystemIndependentPath(this.myPanel.myWindowsIconPath));
        JavaFxApplicationIcons javaFxApplicationIcons = icons;
        if (javaFxApplicationIcons == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/packaging/JavaFxApplicationIconsDialog", "getIcons"));
        }
        return javaFxApplicationIcons;
    }

    private boolean isValidPath(TextFieldWithBrowseButton withBrowseButton, ProjectFileIndex index, String osName) {
        String text = withBrowseButton.getText();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return true;
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(text.trim()), (boolean)false);
        if (virtualFile == null || !virtualFile.exists() || virtualFile.isDirectory()) {
            Messages.showErrorDialog((Component)this.myPanel.myWholePanel, (String)(osName + " icon file should exist"));
            return false;
        }
        if (!index.isInContent(virtualFile)) {
            Messages.showErrorDialog((Component)this.myPanel.myWholePanel, (String)(osName + " icon file should be inside the project content"));
            return false;
        }
        return true;
    }

    private static void addBrowseListener(TextFieldWithBrowseButton withBrowseButton, String extension, Project project) {
        withBrowseButton.addBrowseFolderListener("Choose Icon File", "Select icon file (*." + extension + ") for the resulting application", project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withFileFilter(file -> extension.equalsIgnoreCase(file.getExtension())));
    }

    protected static class Panel {
        JPanel myWholePanel;
        private TextFieldWithBrowseButton myLinuxIconPath;
        private TextFieldWithBrowseButton myMacIconPath;
        private TextFieldWithBrowseButton myWindowsIconPath;

        protected Panel() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            TextFieldWithBrowseButton textFieldWithBrowseButton;
            TextFieldWithBrowseButton textFieldWithBrowseButton2;
            TextFieldWithBrowseButton textFieldWithBrowseButton3;
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JLabel jLabel = new JLabel();
            jLabel.setText("Linux Icon");
            jLabel.setDisplayedMnemonic('L');
            jLabel.setDisplayedMnemonicIndex(0);
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myLinuxIconPath = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
            jPanel.add((Component)textFieldWithBrowseButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText("Mac Icon");
            jLabel2.setDisplayedMnemonic('M');
            jLabel2.setDisplayedMnemonicIndex(0);
            jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myMacIconPath = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
            jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
            JLabel jLabel3 = new JLabel();
            jLabel3.setText("Windows Icon");
            jLabel3.setDisplayedMnemonic('W');
            jLabel3.setDisplayedMnemonicIndex(0);
            jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myWindowsIconPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
            jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
            jLabel.setLabelFor((Component)textFieldWithBrowseButton3);
            jLabel2.setLabelFor((Component)textFieldWithBrowseButton2);
            jLabel3.setLabelFor((Component)textFieldWithBrowseButton);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }
    }
}

