/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.filesystem.jdk7;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.gradle.internal.nativeintegration.filesystem.Symlink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jdk7Symlink
implements Symlink {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jdk7Symlink.class);
    private final boolean symlinksSupported;

    public Jdk7Symlink() {
        this(Jdk7Symlink.doesSystemSupportSymlinks());
    }

    protected Jdk7Symlink(boolean symlinksSupported) {
        this.symlinksSupported = symlinksSupported;
    }

    public boolean isSymlinkSupported() {
        return this.symlinksSupported;
    }

    public void symlink(File link, File target) throws Exception {
        link.getParentFile().mkdirs();
        Files.createSymbolicLink(link.toPath(), target.toPath(), new FileAttribute[0]);
    }

    public boolean isSymlink(File suspect) {
        return Files.isSymbolicLink(suspect.toPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean doesSystemSupportSymlinks() {
        Path sourceFile = null;
        Path linkFile = null;
        try {
            sourceFile = Files.createTempFile("symlink", "test", new FileAttribute[0]);
            linkFile = Files.createTempFile("symlink", "test_link", new FileAttribute[0]);
            Files.delete(linkFile);
            Files.createSymbolicLink(linkFile, sourceFile, new FileAttribute[0]);
            boolean bl = true;
            return bl;
        }
        catch (InternalError e) {
            if (e.getMessage().contains("Should not get here")) {
                LOGGER.debug("Unable to create a symlink. Your system is hitting JDK bug id JDK-8046686. Symlink support disabled.", (Throwable)e);
            } else {
                LOGGER.debug("Unexpected internal error", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        catch (UnsupportedOperationException e2) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                if (sourceFile != null && sourceFile.toFile().exists()) {
                    Files.delete(sourceFile);
                }
                if (linkFile != null && linkFile.toFile().exists()) {
                    Files.delete(linkFile);
                }
            }
            catch (IOException e) {}
        }
    }
}

