/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.util.ProcessingContext;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.XmlFileHeader;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FileContentPattern
extends ObjectPattern<FileContent, FileContentPattern> {
    private FileContentPattern() {
        super(FileContent.class);
    }

    public static FileContentPattern fileContent() {
        return new FileContentPattern();
    }

    public FileContentPattern withName(final @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/framework/detection/FileContentPattern", "withName"));
        }
        return (FileContentPattern)this.with(new PatternCondition<FileContent>("withName"){

            @Override
            public boolean accepts(@NotNull FileContent fileContent, ProcessingContext context) {
                if (fileContent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/framework/detection/FileContentPattern$1", "accepts"));
                }
                return name.equals(fileContent.getFileName());
            }
        });
    }

    public FileContentPattern withName(final StringPattern namePattern) {
        return (FileContentPattern)this.with(new PatternCondition<FileContent>("withName"){

            @Override
            public boolean accepts(@NotNull FileContent fileContent, ProcessingContext context) {
                if (fileContent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/framework/detection/FileContentPattern$2", "accepts"));
                }
                return namePattern.accepts(fileContent.getFileName());
            }
        });
    }

    public FileContentPattern inDirectory(final @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/framework/detection/FileContentPattern", "inDirectory"));
        }
        return (FileContentPattern)this.with(new PatternCondition<FileContent>("inDirectory"){

            @Override
            public boolean accepts(@NotNull FileContent fileContent, ProcessingContext context) {
                if (fileContent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/framework/detection/FileContentPattern$3", "accepts"));
                }
                return name.equals(fileContent.getFile().getParent().getName());
            }
        });
    }

    public FileContentPattern xmlWithRootTag(final @NotNull String rootTag) {
        if (rootTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTag", "com/intellij/framework/detection/FileContentPattern", "xmlWithRootTag"));
        }
        return (FileContentPattern)this.with(new PatternCondition<FileContent>("withRootTag"){

            @Override
            public boolean accepts(@NotNull FileContent fileContent, ProcessingContext context) {
                if (fileContent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/framework/detection/FileContentPattern$4", "accepts"));
                }
                try {
                    return rootTag.equals(FileContentPattern.parseHeaderWithException(fileContent).getRootTagLocalName());
                }
                catch (IOException e) {
                    return false;
                }
            }
        });
    }

    public FileContentPattern xmlWithRootTagNamespace(String namespace) {
        return this.xmlWithRootTagNamespace((ElementPattern<String>)StandardPatterns.string().equalTo(namespace));
    }

    public FileContentPattern xmlWithRootTagNamespace(final ElementPattern<String> namespacePattern) {
        return (FileContentPattern)this.with(new PatternCondition<FileContent>("xmlWithRootTagNamespace"){

            @Override
            public boolean accepts(@NotNull FileContent fileContent, ProcessingContext context) {
                if (fileContent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/framework/detection/FileContentPattern$5", "accepts"));
                }
                try {
                    String rootTagNamespace = FileContentPattern.parseHeaderWithException(fileContent).getRootTagNamespace();
                    return rootTagNamespace != null && namespacePattern.accepts(rootTagNamespace, context);
                }
                catch (IOException e) {
                    return false;
                }
            }
        });
    }

    @NotNull
    private static XmlFileHeader parseHeaderWithException(FileContent fileContent) throws IOException {
        XmlFileHeader xmlFileHeader = NanoXmlUtil.parseHeaderWithException(CharArrayUtil.readerFromCharSequence((CharSequence)fileContent.getContentAsText()));
        if (xmlFileHeader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/FileContentPattern", "parseHeaderWithException"));
        }
        return xmlFileHeader;
    }
}

