/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Key;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataManager {
    @NonNls
    public static final String CLIENT_PROPERTY_DATA_PROVIDER = "DataProvider";

    public static DataManager getInstance() {
        return ApplicationManager.getApplication().getComponent(DataManager.class);
    }

    @NotNull
    public abstract DataContext getDataContext();

    public abstract AsyncResult<DataContext> getDataContextFromFocus();

    public abstract DataContext getDataContext(Component var1);

    public abstract DataContext getDataContext(@NotNull Component var1, int var2, int var3);

    public abstract <T> void saveInDataContext(@Nullable DataContext var1, @NotNull Key<T> var2, @Nullable T var3);

    @Nullable
    public abstract <T> T loadFromDataContext(@NotNull DataContext var1, @NotNull Key<T> var2);

    public static void registerDataProvider(@NotNull JComponent component, @NotNull DataProvider provider) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/DataManager", "registerDataProvider"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/DataManager", "registerDataProvider"));
        }
        component.putClientProperty(CLIENT_PROPERTY_DATA_PROVIDER, provider);
    }

    @Nullable
    public static DataProvider getDataProvider(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/DataManager", "getDataProvider"));
        }
        return (DataProvider)component.getClientProperty(CLIENT_PROPERTY_DATA_PROVIDER);
    }

    public static void removeDataProvider(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/DataManager", "removeDataProvider"));
        }
        component.putClientProperty(CLIENT_PROPERTY_DATA_PROVIDER, null);
    }
}

