/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.ColorBlindness;
import com.intellij.ide.ui.DaltonizationFilter;
import com.intellij.ide.ui.MatrixFilter;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ComponentTreeEventDispatcher;
import com.intellij.util.EventDispatcher;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.ImageFilter;
import java.util.EventListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import sun.swing.SwingUtilities2;

@State(name="UISettings", storages={@Storage(value="ui.lnf.xml")})
public class UISettings
extends SimpleModificationTracker
implements PersistentStateComponent<UISettings> {
    public static final int TABS_NONE = 0;
    private static UISettings ourSettings;
    @Property(filter=FontFilter.class)
    public String FONT_FACE;
    @Property(filter=FontFilter.class)
    public int FONT_SIZE;
    public int RECENT_FILES_LIMIT = 50;
    public int CONSOLE_COMMAND_HISTORY_LIMIT = 300;
    public boolean OVERRIDE_CONSOLE_CYCLE_BUFFER_SIZE = false;
    public int CONSOLE_CYCLE_BUFFER_SIZE_KB = 1024;
    public int EDITOR_TAB_LIMIT = 10;
    public boolean REUSE_NOT_MODIFIED_TABS = false;
    public boolean ANIMATE_WINDOWS = true;
    @Deprecated
    public int ANIMATION_SPEED = 4000;
    public int ANIMATION_DURATION = 300;
    public boolean SHOW_TOOL_WINDOW_NUMBERS = true;
    public boolean HIDE_TOOL_STRIPES = true;
    public boolean WIDESCREEN_SUPPORT = false;
    public boolean LEFT_HORIZONTAL_SPLIT = false;
    public boolean RIGHT_HORIZONTAL_SPLIT = false;
    public boolean SHOW_EDITOR_TOOLTIP = true;
    public boolean SHOW_MEMORY_INDICATOR = false;
    public boolean ALLOW_MERGE_BUTTONS = true;
    public boolean SHOW_MAIN_TOOLBAR = false;
    public boolean SHOW_STATUS_BAR = true;
    public boolean SHOW_NAVIGATION_BAR = true;
    public boolean ALWAYS_SHOW_WINDOW_BUTTONS = false;
    public boolean CYCLE_SCROLLING = true;
    public boolean SCROLL_TAB_LAYOUT_IN_EDITOR = true;
    public boolean HIDE_TABS_IF_NEED = true;
    public boolean SHOW_CLOSE_BUTTON = true;
    public int EDITOR_TAB_PLACEMENT = 1;
    public boolean HIDE_KNOWN_EXTENSION_IN_TABS = false;
    public boolean SHOW_ICONS_IN_QUICK_NAVIGATION = true;
    public boolean CLOSE_NON_MODIFIED_FILES_FIRST = false;
    public boolean ACTIVATE_MRU_EDITOR_ON_CLOSE = false;
    public boolean ACTIVATE_RIGHT_EDITOR_ON_CLOSE = false;
    public AntialiasingType IDE_AA_TYPE = AntialiasingType.SUBPIXEL;
    public AntialiasingType EDITOR_AA_TYPE = AntialiasingType.SUBPIXEL;
    public ColorBlindness COLOR_BLINDNESS;
    public boolean USE_LCD_RENDERING_IN_EDITOR = true;
    public boolean MOVE_MOUSE_ON_DEFAULT_BUTTON = false;
    public boolean ENABLE_ALPHA_MODE = false;
    public int ALPHA_MODE_DELAY = 1500;
    public float ALPHA_MODE_RATIO = 0.5f;
    public int MAX_CLIPBOARD_CONTENTS = 5;
    public boolean OVERRIDE_NONIDEA_LAF_FONTS = false;
    public boolean SHOW_ICONS_IN_MENUS = true;
    public boolean DISABLE_MNEMONICS = SystemInfo.isMac;
    public boolean DISABLE_MNEMONICS_IN_CONTROLS = false;
    public boolean USE_SMALL_LABELS_ON_TABS = SystemInfo.isMac;
    public boolean SORT_LOOKUP_ELEMENTS_LEXICOGRAPHICALLY = false;
    public int MAX_LOOKUP_WIDTH2 = 500;
    public int MAX_LOOKUP_LIST_HEIGHT = 11;
    public boolean HIDE_NAVIGATION_ON_FOCUS_LOSS = true;
    public boolean DND_WITH_PRESSED_ALT_ONLY = false;
    public boolean FILE_COLORS_IN_PROJECT_VIEW = false;
    public boolean DEFAULT_AUTOSCROLL_TO_SOURCE = false;
    @Transient
    public boolean PRESENTATION_MODE = false;
    public int PRESENTATION_MODE_FONT_SIZE = 24;
    public boolean MARK_MODIFIED_TABS_WITH_ASTERISK = false;
    public boolean SHOW_TABS_TOOLTIPS = true;
    public boolean SHOW_DIRECTORY_FOR_NON_UNIQUE_FILENAMES = true;
    public boolean NAVIGATE_TO_PREVIEW = false;
    public boolean SORT_BOOKMARKS = false;
    public boolean MERGE_EQUAL_STACKTRACES = true;
    private final EventDispatcher<UISettingsListener> myDispatcher = EventDispatcher.create(UISettingsListener.class);
    private final ComponentTreeEventDispatcher<UISettingsListener> myTreeDispatcher = ComponentTreeEventDispatcher.create(UISettingsListener.class);
    public static final boolean FORCE_USE_FRACTIONAL_METRICS;

    public static UISettings getInstance() {
        ourSettings = ServiceManager.getService(UISettings.class);
        return ourSettings;
    }

    public static UISettings getShadowInstance() {
        Application application = ApplicationManager.getApplication();
        UISettings settings = application == null ? null : UISettings.getInstance();
        return settings == null ? new UISettings() : settings;
    }

    public UISettings() {
        this.tweakPlatformDefaults();
        this.setSystemFontFaceAndSize();
        Boolean scrollToSource = WelcomeWizardUtil.getAutoScrollToSource();
        if (scrollToSource != null) {
            this.DEFAULT_AUTOSCROLL_TO_SOURCE = scrollToSource;
        }
    }

    private void tweakPlatformDefaults() {
        if (PlatformUtils.isAppCode()) {
            this.SCROLL_TAB_LAYOUT_IN_EDITOR = true;
            this.ACTIVATE_RIGHT_EDITOR_ON_CLOSE = true;
            this.SHOW_ICONS_IN_MENUS = false;
        }
    }

    public void addUISettingsListener(UISettingsListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void addUISettingsListener(@NotNull UISettingsListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ide/ui/UISettings", "addUISettingsListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/ide/ui/UISettings", "addUISettingsListener"));
        }
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public void fireUISettingsChanged() {
        this.incModificationCount();
        ((UISettingsListener)this.myDispatcher.getMulticaster()).uiSettingsChanged(this);
        if (ourSettings == this) {
            ((UISettingsListener)this.myTreeDispatcher.getMulticaster()).uiSettingsChanged(this);
            ((UISettingsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(UISettingsListener.TOPIC)).uiSettingsChanged(this);
        }
        IconLoader.setFilter((ImageFilter)(Registry.is((String)"color.blindness.daltonization") ? DaltonizationFilter.get(this.COLOR_BLINDNESS) : MatrixFilter.get(this.COLOR_BLINDNESS)));
    }

    public void removeUISettingsListener(UISettingsListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    private void setSystemFontFaceAndSize() {
        if (this.FONT_FACE == null || this.FONT_SIZE <= 0) {
            Pair<String, Integer> fontData = UISettings.getSystemFontFaceAndSize();
            this.FONT_FACE = (String)fontData.first;
            this.FONT_SIZE = (Integer)fontData.second;
        }
    }

    private static Pair<String, Integer> getSystemFontFaceAndSize() {
        Pair fontData = UIUtil.getSystemFontData();
        if (fontData != null) {
            return fontData;
        }
        return Pair.create((Object)"Dialog", (Object)12);
    }

    private static boolean hasDefaultFontSetting(UISettings settings) {
        Pair<String, Integer> fontData = UISettings.getSystemFontFaceAndSize();
        return ((String)fontData.first).equals(settings.FONT_FACE) && ((Integer)fontData.second).equals(settings.FONT_SIZE);
    }

    @Override
    public UISettings getState() {
        return this;
    }

    @Override
    public void loadState(UISettings object) {
        XmlSerializerUtil.copyBean((Object)object, (Object)this);
        if (this.EDITOR_TAB_PLACEMENT != 0 && this.EDITOR_TAB_PLACEMENT != 1 && this.EDITOR_TAB_PLACEMENT != 2 && this.EDITOR_TAB_PLACEMENT != 3 && this.EDITOR_TAB_PLACEMENT != 4) {
            this.EDITOR_TAB_PLACEMENT = 1;
        }
        if (this.ALPHA_MODE_DELAY < 0) {
            this.ALPHA_MODE_DELAY = 1500;
        }
        if (this.ALPHA_MODE_RATIO < 0.0f || this.ALPHA_MODE_RATIO > 1.0f) {
            this.ALPHA_MODE_RATIO = 0.5f;
        }
        this.setSystemFontFaceAndSize();
        boolean fontIsValid = UIUtil.isValidFont((Font)new Font(this.FONT_FACE, 0, this.FONT_SIZE));
        if (!fontIsValid) {
            String[] fontNames;
            String[] preferredFonts;
            for (String preferredFont : preferredFonts = new String[]{"dialog", "Arial", "Tahoma"}) {
                if (!UIUtil.isValidFont((Font)new Font(preferredFont, 0, this.FONT_SIZE))) continue;
                this.FONT_FACE = preferredFont;
                fontIsValid = true;
                break;
            }
            if (!fontIsValid && (fontNames = UIUtil.getValidFontNames((boolean)false)).length > 0) {
                this.FONT_FACE = fontNames[0];
            }
        }
        if (this.MAX_CLIPBOARD_CONTENTS <= 0) {
            this.MAX_CLIPBOARD_CONTENTS = 5;
        }
        this.fireUISettingsChanged();
    }

    public static void setupFractionalMetrics(Graphics2D g2d) {
        if (FORCE_USE_FRACTIONAL_METRICS) {
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
    }

    public static void setupAntialiasing(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, UIUtil.getLcdContrastValue());
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            UIUtil.applyRenderingHints((Graphics)g);
            return;
        }
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings != null) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope(false));
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        UISettings.setupFractionalMetrics(g2d);
    }

    public static void setupComponentAntialiasing(JComponent component) {
        component.putClientProperty(SwingUtilities2.AA_TEXT_PROPERTY_KEY, AntialiasingType.getAAHintForSwingComponent());
    }

    static {
        FORCE_USE_FRACTIONAL_METRICS = SystemProperties.getBooleanProperty((String)"idea.force.use.fractional.metrics", (boolean)false);
    }

    public static class FontFilter
    implements SerializationFilter {
        public boolean accepts(@NotNull Accessor accessor, @NotNull Object bean) {
            if (accessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/ide/ui/UISettings$FontFilter", "accepts"));
            }
            if (bean == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/ide/ui/UISettings$FontFilter", "accepts"));
            }
            UISettings settings = (UISettings)bean;
            return !UISettings.hasDefaultFontSetting(settings);
        }
    }
}

