/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.undo;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class UndoUtil {
    private UndoUtil() {
    }

    public static void markPsiFileForUndo(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/command/undo/UndoUtil", "markPsiFileForUndo"));
        }
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance(project).getDocument(file);
        if (document == null) {
            return;
        }
        CommandProcessor.getInstance().addAffectedDocuments(project, document);
    }

    public static void markVirtualFileForUndo(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/command/undo/UndoUtil", "markVirtualFileForUndo"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/command/undo/UndoUtil", "markVirtualFileForUndo"));
        }
        CommandProcessor.getInstance().addAffectedFiles(project, file);
    }

    public static void disableUndoFor(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/command/undo/UndoUtil", "disableUndoFor"));
        }
        document.putUserData(UndoConstants.DONT_RECORD_UNDO, Boolean.TRUE);
    }

    public static boolean isUndoDisabledFor(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/command/undo/UndoUtil", "isUndoDisabledFor"));
        }
        return Boolean.TRUE.equals(document.getUserData(UndoConstants.DONT_RECORD_UNDO));
    }
}

