/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.util.containers.HashMap;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LibraryData
extends AbstractNamedData
implements Named {
    private static final long serialVersionUID = 1L;
    private final Map<LibraryPathType, Set<String>> myPaths;
    private final boolean myUnresolved;

    public LibraryData(@NotNull ProjectSystemId owner, @NotNull String name) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/openapi/externalSystem/model/project/LibraryData", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/externalSystem/model/project/LibraryData", "<init>"));
        }
        this(owner, name, false);
    }

    public LibraryData(@NotNull ProjectSystemId owner, @NotNull String name, boolean unresolved) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/openapi/externalSystem/model/project/LibraryData", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/externalSystem/model/project/LibraryData", "<init>"));
        }
        super(owner, name, name.isEmpty() ? "" : String.format("%s: %s", owner.getReadableName(), name));
        this.myPaths = new HashMap();
        this.myUnresolved = unresolved;
    }

    public boolean isUnresolved() {
        return this.myUnresolved;
    }

    @NotNull
    public Set<String> getPaths(@NotNull LibraryPathType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/externalSystem/model/project/LibraryData", "getPaths"));
        }
        Set<String> result = this.myPaths.get((Object)type);
        Set<Object> set = result == null ? Collections.emptySet() : result;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/LibraryData", "getPaths"));
        }
        return set;
    }

    public void addPath(@NotNull LibraryPathType type, @NotNull String path2) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/externalSystem/model/project/LibraryData", "addPath"));
        }
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/externalSystem/model/project/LibraryData", "addPath"));
        }
        Set<String> paths = this.myPaths.get((Object)type);
        if (paths == null) {
            paths = new LinkedHashSet<String>();
            this.myPaths.put(type, paths);
        }
        paths.add(ExternalSystemApiUtil.toCanonicalPath(path2));
    }

    public void forgetAllPaths() {
        this.myPaths.clear();
    }

    @Override
    public int hashCode() {
        int result = this.myPaths.hashCode();
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.myUnresolved ? 0 : 1);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        LibraryData that = (LibraryData)o;
        return super.equals(that) && this.myUnresolved == that.myUnresolved && this.myPaths.equals(that.myPaths);
    }

    public String toString() {
        return String.format("library %s%s", this.getExternalName(), this.myUnresolved ? "(unresolved)" : "");
    }
}

