/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChooser {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileChooser.FileChooser");

    private FileChooser() {
    }

    @NotNull
    public static VirtualFile[] chooseFiles(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable VirtualFile toSelect) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/FileChooser", "chooseFiles"));
        }
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles(descriptor, null, project, toSelect);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/FileChooser", "chooseFiles"));
        }
        return virtualFileArray;
    }

    @NotNull
    public static VirtualFile[] chooseFiles(@NotNull FileChooserDescriptor descriptor, @Nullable Component parent, @Nullable Project project, @Nullable VirtualFile toSelect) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/FileChooser", "chooseFiles"));
        }
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor, project, parent);
        VirtualFile[] virtualFileArray = chooser.choose(project, toSelect);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/FileChooser", "chooseFiles"));
        }
        return virtualFileArray;
    }

    @Nullable
    public static VirtualFile chooseFile(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable VirtualFile toSelect) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/FileChooser", "chooseFile"));
        }
        return FileChooser.chooseFile(descriptor, null, project, toSelect);
    }

    @Nullable
    public static VirtualFile chooseFile(@NotNull FileChooserDescriptor descriptor, @Nullable Component parent, @Nullable Project project, @Nullable VirtualFile toSelect) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/FileChooser", "chooseFile"));
        }
        LOG.assertTrue(!descriptor.isChooseMultiple());
        return (VirtualFile)ArrayUtil.getFirstElement((Object[])FileChooser.chooseFiles(descriptor, parent, project, toSelect));
    }

    public static void chooseFiles(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable VirtualFile toSelect, @NotNull Consumer<List<VirtualFile>> callback) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/FileChooser", "chooseFiles"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/fileChooser/FileChooser", "chooseFiles"));
        }
        FileChooser.chooseFiles(descriptor, project, null, toSelect, callback);
    }

    public static void chooseFiles(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable Component parent, @Nullable VirtualFile toSelect, @NotNull Consumer<List<VirtualFile>> callback) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/FileChooser", "chooseFiles"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/fileChooser/FileChooser", "chooseFiles"));
        }
        FileChooserFactory factory = FileChooserFactory.getInstance();
        PathChooserDialog pathChooser = factory.createPathChooser(descriptor, project, parent);
        pathChooser.choose(toSelect, callback);
    }

    public static void chooseFile(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable VirtualFile toSelect, @NotNull Consumer<VirtualFile> callback) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/FileChooser", "chooseFile"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/fileChooser/FileChooser", "chooseFile"));
        }
        FileChooser.chooseFile(descriptor, project, null, toSelect, callback);
    }

    public static void chooseFile(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, @Nullable Component parent, @Nullable VirtualFile toSelect, @NotNull Consumer<VirtualFile> callback) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/FileChooser", "chooseFile"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/fileChooser/FileChooser", "chooseFile"));
        }
        LOG.assertTrue(!descriptor.isChooseMultiple());
        FileChooser.chooseFiles(descriptor, project, parent, toSelect, (Consumer<List<VirtualFile>>)((Consumer)files -> {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/fileChooser/FileChooser", "lambda$chooseFile$0"));
            }
            callback.consume(files.get(0));
        }));
    }

    public static interface FileChooserConsumer
    extends Consumer<List<VirtualFile>> {
        public void cancelled();
    }
}

