/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class NativeFileType
implements INativeFileType {
    public static final NativeFileType INSTANCE = new NativeFileType();

    private NativeFileType() {
    }

    @Override
    @NotNull
    public String getName() {
        if ("Native" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/NativeFileType", "getName"));
        }
        return "Native";
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Files opened in associated applications" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/NativeFileType", "getDescription"));
        }
        return "Files opened in associated applications";
    }

    @Override
    @NotNull
    public String getDefaultExtension() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/NativeFileType", "getDefaultExtension"));
        }
        return "";
    }

    @Override
    public Icon getIcon() {
        return AllIcons.FileTypes.Custom;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/NativeFileType", "getCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileTypes/NativeFileType", "getCharset"));
        }
        return null;
    }

    @Override
    public boolean openFileInAssociatedApplication(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/NativeFileType", "openFileInAssociatedApplication"));
        }
        return NativeFileType.openAssociatedApplication(file);
    }

    @Override
    public boolean useNativeIcon() {
        return true;
    }

    public static boolean openAssociatedApplication(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/NativeFileType", "openAssociatedApplication"));
        }
        ArrayList<String> commands = new ArrayList<String>();
        if (SystemInfo.isWindows) {
            commands.add("rundll32.exe");
            commands.add("url.dll,FileProtocolHandler");
        } else if (SystemInfo.isMac) {
            commands.add("/usr/bin/open");
        } else if (SystemInfo.hasXdgOpen()) {
            commands.add("xdg-open");
        } else {
            return false;
        }
        commands.add(file.getPath());
        try {
            new GeneralCommandLine(commands).createProcess();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

