/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.BaseCheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.BeforeCheckinDialogHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import org.jetbrains.annotations.NotNull;

public abstract class VcsCheckinHandlerFactory
implements BaseCheckinHandlerFactory {
    public static final ExtensionPointName<VcsCheckinHandlerFactory> EP_NAME = ExtensionPointName.create((String)"com.intellij.vcsCheckinHandlerFactory");
    private VcsKey myKey;

    protected VcsCheckinHandlerFactory(@NotNull VcsKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/vcs/checkin/VcsCheckinHandlerFactory", "<init>"));
        }
        this.myKey = key;
    }

    @Override
    @NotNull
    public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/openapi/vcs/checkin/VcsCheckinHandlerFactory", "createHandler"));
        }
        if (commitContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitContext", "com/intellij/openapi/vcs/checkin/VcsCheckinHandlerFactory", "createHandler"));
        }
        if (!panel.vcsIsAffected(this.myKey.getName())) {
            CheckinHandler checkinHandler = CheckinHandler.DUMMY;
            if (checkinHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/checkin/VcsCheckinHandlerFactory", "createHandler"));
            }
            return checkinHandler;
        }
        CheckinHandler checkinHandler = this.createVcsHandler(panel);
        if (checkinHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/checkin/VcsCheckinHandlerFactory", "createHandler"));
        }
        return checkinHandler;
    }

    @NotNull
    protected abstract CheckinHandler createVcsHandler(CheckinProjectPanel var1);

    public VcsKey getKey() {
        return this.myKey;
    }

    @Override
    public BeforeCheckinDialogHandler createSystemReadyHandler(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/checkin/VcsCheckinHandlerFactory", "createSystemReadyHandler"));
        }
        return null;
    }
}

