/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.DomElementPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDomValuePattern<T>
extends DomElementPattern<GenericDomValue<T>, GenericDomValuePattern<T>> {
    private static final InitialPatternCondition CONDITION = new InitialPatternCondition(GenericDomValue.class){

        @Override
        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            return o instanceof GenericDomValue;
        }
    };

    protected GenericDomValuePattern() {
        super(CONDITION);
    }

    protected GenericDomValuePattern(final Class<T> aClass) {
        super(new InitialPatternCondition(aClass){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof GenericDomValue && aClass.equals(DomUtil.getGenericValueParameter(((GenericDomValue)o).getDomElementType()));
            }
        });
    }

    public GenericDomValuePattern<T> withStringValue(final ElementPattern<String> pattern) {
        return (GenericDomValuePattern)this.with(new PatternCondition<GenericDomValue<T>>("withStringValue"){

            @Override
            public boolean accepts(@NotNull GenericDomValue<T> genericDomValue, ProcessingContext context) {
                if (genericDomValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericDomValue", "com/intellij/patterns/GenericDomValuePattern$3", "accepts"));
                }
                return pattern.accepts(genericDomValue.getStringValue(), context);
            }
        });
    }

    public GenericDomValuePattern<T> withValue(@NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/patterns/GenericDomValuePattern", "withValue"));
        }
        return this.withValue((ElementPattern<?>)StandardPatterns.object(value));
    }

    public GenericDomValuePattern<T> withValue(final ElementPattern<?> pattern) {
        return (GenericDomValuePattern)this.with(new PatternCondition<GenericDomValue<T>>("withValue"){

            @Override
            public boolean accepts(@NotNull GenericDomValue<T> genericDomValue, ProcessingContext context) {
                if (genericDomValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericDomValue", "com/intellij/patterns/GenericDomValuePattern$4", "accepts"));
                }
                return pattern.accepts(genericDomValue.getValue(), context);
            }
        });
    }
}

