/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.util.AbstractQuery;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class SearchRequestQuery
extends AbstractQuery<PsiReference> {
    private final Project myProject;
    private final SearchRequestCollector myRequests;

    public SearchRequestQuery(@NotNull Project project, @NotNull SearchRequestCollector requests) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/SearchRequestQuery", "<init>"));
        }
        if (requests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/psi/search/SearchRequestQuery", "<init>"));
        }
        this.myProject = project;
        this.myRequests = requests;
    }

    @Override
    @NotNull
    protected AsyncFuture<Boolean> processResultsAsync(@NotNull Processor<PsiReference> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/search/SearchRequestQuery", "processResultsAsync"));
        }
        AsyncFuture<Boolean> asyncFuture = PsiSearchHelper.SERVICE.getInstance(this.myProject).processRequestsAsync(this.myRequests, consumer);
        if (asyncFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/SearchRequestQuery", "processResultsAsync"));
        }
        return asyncFuture;
    }

    @Override
    protected boolean processResults(@NotNull Processor<PsiReference> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/search/SearchRequestQuery", "processResults"));
        }
        return PsiSearchHelper.SERVICE.getInstance(this.myProject).processRequests(this.myRequests, consumer);
    }

    public String toString() {
        return this.myRequests.toString();
    }
}

