/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.marker;

import com.michaelbaranov.microba.common.BoundedTableModel;
import com.michaelbaranov.microba.common.MicrobaComponent;
import com.michaelbaranov.microba.marker.DefaultMarkerModel;
import com.michaelbaranov.microba.marker.MarkerMutationModel;
import com.michaelbaranov.microba.marker.ui.MarkerBarUI;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;

public class MarkerBar
extends MicrobaComponent {
    public static final String PROPERTY_DATA_MODEL = "dataModel";
    public static final String PROPERTY_SELECTION_MODEL = "selectionModel";
    public static final String PROPERTY_MUTATION_MODEL = "mutationModel";
    public static final String PROPERTY_ORIENTATION = "orientation";
    public static final String PROPERTY_POSITION_COLUMN = "positionColumn";
    public static final String PROPERTY_COLOR_COLUMN = "colorColumn";
    public static final String PROPERTY_FLIP = "fliped";
    private static final String uiClassID = "microba.MarkerBarUI";
    private BoundedTableModel dataModel = null;
    private ListSelectionModel selectionModel = null;
    private MarkerMutationModel mutationModel = null;
    private int positionColumn = 0;
    private int colorColumn = -1;
    private int orientation = 0;
    private boolean fliped = false;

    public MarkerBar() {
        DefaultMarkerModel markerModel = new DefaultMarkerModel();
        this.dataModel = markerModel;
        this.selectionModel = markerModel;
        this.mutationModel = markerModel;
        this.setFocusable(true);
        this.updateUI();
    }

    public MarkerBar(int orientation) {
        DefaultMarkerModel markerModel = new DefaultMarkerModel();
        this.dataModel = markerModel;
        this.selectionModel = markerModel;
        this.mutationModel = markerModel;
        this.orientation = orientation;
        this.setFocusable(true);
        this.updateUI();
    }

    public MarkerBar(BoundedTableModel dataModel) {
        this.dataModel = dataModel;
        this.selectionModel = new DefaultListSelectionModel();
        this.mutationModel = null;
        this.setFocusable(true);
        this.updateUI();
    }

    public MarkerBar(BoundedTableModel dataModel, ListSelectionModel selectionModel) {
        this.dataModel = dataModel;
        this.selectionModel = selectionModel;
        this.mutationModel = null;
        this.setFocusable(true);
        this.updateUI();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public BoundedTableModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(BoundedTableModel model) {
        BoundedTableModel oldModel = this.dataModel;
        this.dataModel = model;
        this.firePropertyChange(PROPERTY_DATA_MODEL, oldModel, model);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        int oldOrientation = this.orientation;
        this.orientation = orientation;
        this.firePropertyChange(PROPERTY_ORIENTATION, oldOrientation, orientation);
    }

    public MarkerMutationModel getMutationModel() {
        return this.mutationModel;
    }

    public void setMutationModel(MarkerMutationModel mutationModel) {
        MarkerMutationModel oldMutationModel = this.mutationModel;
        this.mutationModel = mutationModel;
        this.firePropertyChange(PROPERTY_MUTATION_MODEL, oldMutationModel, mutationModel);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        ListSelectionModel oldSelectionModel = this.selectionModel;
        this.selectionModel = selectionModel;
        this.firePropertyChange(PROPERTY_SELECTION_MODEL, oldSelectionModel, selectionModel);
    }

    public int getPositionColumn() {
        return this.positionColumn;
    }

    public void setPositionColumn(int positionColumn) {
        int oldDataColumn = this.positionColumn;
        this.positionColumn = positionColumn;
        this.firePropertyChange(PROPERTY_POSITION_COLUMN, oldDataColumn, positionColumn);
    }

    public int getColorColumn() {
        return this.colorColumn;
    }

    public void setColorColumn(int colorColumn) {
        int old = this.colorColumn;
        this.colorColumn = colorColumn;
        this.firePropertyChange(PROPERTY_COLOR_COLUMN, old, colorColumn);
    }

    public int getMarkerSideGap() {
        return ((MarkerBarUI)this.getUI()).getMarkerSideGap();
    }

    public boolean isFliped() {
        return this.fliped;
    }

    public void setFliped(boolean flip) {
        boolean old = this.fliped;
        this.fliped = flip;
        this.firePropertyChange(PROPERTY_FLIP, old, flip);
    }
}

