/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvshandlers;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.cvshandlers.AllFilesInProject;
import com.intellij.cvsSupport2.cvshandlers.SelectedFiles;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;

public abstract class FileSetToBeUpdated {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvshandlers.FileSetToBeUpdated");
    public static final FileSetToBeUpdated EMPTY = new FileSetToBeUpdated(){

        @Override
        public void refreshFilesAsync(Runnable postRunnable) {
            if (postRunnable != null) {
                postRunnable.run();
            }
        }

        @Override
        public void refreshFilesSync() {
        }

        @Override
        protected void setSynchronizingFilesTextToProgress(ProgressIndicator progressIndicator) {
        }
    };

    public static FileSetToBeUpdated allFiles() {
        return new AllFilesInProject();
    }

    public static FileSetToBeUpdated selectedFiles(FilePath[] files) {
        return new SelectedFiles(files);
    }

    public static FileSetToBeUpdated selectedFiles(VirtualFile[] files) {
        return new SelectedFiles(files);
    }

    public abstract void refreshFilesAsync(Runnable var1);

    public abstract void refreshFilesSync();

    protected void setSynchronizingFilesTextToProgress(ProgressIndicator progressIndicator) {
        progressIndicator.setText(CvsBundle.message((String)"progress.text.synchronizing.files", (Object[])new Object[0]));
        progressIndicator.setText2("");
    }
}

