/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.intellij.ide.IdeView;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import icons.AndroidIcons;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidAssetStudioAction
extends AnAction {
    protected AndroidAssetStudioAction(@Nullable String text, @Nullable String description) {
        super(text, description, AndroidIcons.Android);
    }

    protected static boolean isAvailable(DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        return module != null && view != null && view.getDirectories().length != 0 && AndroidFacet.getInstance(module) != null;
    }

    public final void update(AnActionEvent e) {
        e.getPresentation().setVisible(AndroidAssetStudioAction.isAvailable(e.getDataContext()));
    }

    public final void actionPerformed(AnActionEvent e) {
        PsiDirectory dir;
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return;
        }
        AbstractProjectViewPane pane = ProjectView.getInstance((Project)module.getProject()).getCurrentProjectViewPane();
        if (pane instanceof AndroidProjectViewPane) {
            PsiDirectory[] directories = view.getDirectories();
            if (directories.length == 0) {
                return;
            }
            dir = directories[0];
        } else {
            dir = view.getOrChooseDirectory();
        }
        if (dir == null) {
            return;
        }
        VirtualFile targetFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        this.showWizardAndCreateAsset(facet, targetFile);
    }

    protected abstract void showWizardAndCreateAsset(@NotNull AndroidFacet var1, @Nullable VirtualFile var2);
}

