/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.legacy;

import com.android.sdklib.devices.Storage;
import com.android.tools.idea.ui.properties.core.OptionalProperty;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.google.common.base.Optional;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.JBColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class StorageField
extends JPanel {
    public static final Storage.Unit DEFAULT_UNIT = Storage.Unit.MiB;
    private final ComboBoxModel unitModel = new EnumComboBoxModel(Storage.Unit.class);
    private final ComboBox myUnitsCombo = new ComboBox(this.unitModel);
    private final JTextField myValueField = new JTextField();
    private static final LineBorder ERROR_BORDER = new LineBorder((Color)JBColor.RED);
    private final Border myBorder;
    private long myBytes = 0L;
    private Storage.Unit myCurrentUnit = DEFAULT_UNIT;
    private boolean myIgnoreUpdates;
    private final ScopedDataBinder.ComponentBinding<Storage, StorageField> myBinding = new ScopedDataBinder.ComponentBinding<Storage, StorageField>(){

        @Override
        public void setValue(@Nullable Storage newValue, @NotNull StorageField component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/legacy/StorageField$3", "setValue"));
            }
            if (newValue != null) {
                Storage.Unit unit = newValue.getAppropriateUnits();
                String newText = Long.toString(newValue.getSizeAsUnit(unit));
                if (!component.myValueField.getText().equals(newText)) {
                    component.myValueField.setText(newText);
                }
                component.myUnitsCombo.setSelectedItem((Object)unit);
                StorageField.this.myBytes = newValue.getSize();
                StorageField.this.myCurrentUnit = unit;
            }
        }

        @Override
        @Nullable
        public Storage getValue(@NotNull StorageField component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/legacy/StorageField$3", "getValue"));
            }
            StorageField.this.updateBytes();
            return StorageField.this.getCurrentValue();
        }

        @Override
        public void addItemListener(@NotNull ItemListener listener, @NotNull StorageField component) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/avdmanager/legacy/StorageField$3", "addItemListener"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/legacy/StorageField$3", "addItemListener"));
            }
            component.myUnitsCombo.addItemListener(listener);
        }

        @Override
        @Nullable
        public Document getDocument(@NotNull StorageField component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/legacy/StorageField$3", "getDocument"));
            }
            return component.myValueField.getDocument();
        }
    };

    public StorageField() {
        this.setLayout(new BorderLayout(3, 0));
        this.add((Component)this.myValueField, "Center");
        this.add((Component)this.myUnitsCombo, "East");
        this.myUnitsCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer<Storage.Unit>(){

            protected void customizeCellRenderer(@NotNull JList list, Storage.Unit value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/avdmanager/legacy/StorageField$1", "customizeCellRenderer"));
                }
                this.append(value.getDisplayValue());
            }
        });
        this.myUnitsCombo.setSelectedItem((Object)DEFAULT_UNIT);
        ItemListener unitChangeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StorageField.this.myCurrentUnit = (Storage.Unit)StorageField.this.myUnitsCombo.getSelectedItem();
                Storage value = new Storage(StorageField.this.myBytes);
                StorageField.this.myIgnoreUpdates = true;
                StorageField.this.myValueField.setText(Long.toString(value.getSizeAsUnit(StorageField.this.myCurrentUnit)));
                StorageField.this.myIgnoreUpdates = false;
            }
        };
        this.myUnitsCombo.addItemListener(unitChangeListener);
        this.myBorder = this.myValueField.getBorder();
    }

    private void updateBytes() {
        if (this.myIgnoreUpdates) {
            return;
        }
        String text = this.myValueField.getText();
        this.myBytes = 0L;
        if (text != null) {
            try {
                Long valueAsUnits = Long.parseLong(text);
                Storage value = new Storage(valueAsUnits.longValue(), this.myCurrentUnit);
                this.myBytes = value.getSize();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Nullable
    private Storage getCurrentValue() {
        if (this.myBytes <= 0L) {
            return null;
        }
        return new Storage(this.myBytes);
    }

    public ComboBox getUnitsCombo() {
        return this.myUnitsCombo;
    }

    public Dimension getPreferredSizeOfUnitsDropdown() {
        return this.myUnitsCombo.getPreferredSize();
    }

    public ScopedDataBinder.ComponentBinding<Storage, StorageField> getBinding() {
        return this.myBinding;
    }

    public void setError(boolean hasError) {
        if (hasError) {
            this.myValueField.setBorder(ERROR_BORDER);
        } else {
            this.myValueField.setBorder(this.myBorder);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myUnitsCombo.setEnabled(enabled);
        this.myValueField.setEnabled(enabled);
    }

    public final class StorageProperty
    extends OptionalProperty<Storage>
    implements ItemListener {
        @NotNull
        private StorageField myStorageField;

        public StorageProperty(StorageField storageField) {
            if (storageField == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageField", "com/android/tools/idea/avdmanager/legacy/StorageField$StorageProperty", "<init>"));
            }
            this.myStorageField = storageField;
            this.myStorageField.getUnitsCombo().addItemListener((ItemListener)this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        @Override
        protected void setDirectly(@NotNull Optional<Storage> value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/legacy/StorageField$StorageProperty", "setDirectly"));
            }
        }

        @Override
        @NotNull
        public Optional<Storage> get() {
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/legacy/StorageField$StorageProperty", "get"));
            }
            return null;
        }
    }
}

