/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.renderers;

import com.android.tools.idea.editors.gfxtrace.controllers.AtomController;
import com.android.tools.idea.editors.gfxtrace.controllers.StateController;
import com.android.tools.idea.editors.gfxtrace.service.atom.DynamicAtom;
import com.android.tools.idea.editors.gfxtrace.service.memory.MemoryPointer;
import com.android.tools.idea.editors.gfxtrace.service.memory.MemoryRange;
import com.android.tools.idea.editors.gfxtrace.service.memory.PoolID;
import com.android.tools.rpclib.schema.AnyType;
import com.android.tools.rpclib.schema.Array;
import com.android.tools.rpclib.schema.Constant;
import com.android.tools.rpclib.schema.ConstantSet;
import com.android.tools.rpclib.schema.Dynamic;
import com.android.tools.rpclib.schema.Entity;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Interface;
import com.android.tools.rpclib.schema.Map;
import com.android.tools.rpclib.schema.Pointer;
import com.android.tools.rpclib.schema.Primitive;
import com.android.tools.rpclib.schema.Slice;
import com.android.tools.rpclib.schema.Struct;
import com.android.tools.rpclib.schema.Type;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class Render {
    @NotNull
    private static final Logger LOG = Logger.getInstance(Render.class);
    private static final int MAX_DISPLAY = 3;

    public static void render(@NotNull Object value, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (value instanceof Dynamic) {
            Render.render((Dynamic)value, component, attributes);
            return;
        }
        if (value instanceof Field) {
            Render.render((Field)value, component, attributes);
            return;
        }
        if (value instanceof StateController.Node) {
            Render.render((StateController.Node)value, component, attributes);
            return;
        }
        if (value instanceof AtomController.Node) {
            Render.render((AtomController.Node)value, component, attributes);
            return;
        }
        if (value instanceof AtomController.Memory) {
            Render.render((AtomController.Memory)value, component, attributes);
            return;
        }
        if (value instanceof AtomController.Group) {
            Render.render((AtomController.Group)value, component, attributes);
            return;
        }
        if (value instanceof DynamicAtom) {
            Render.render((DynamicAtom)value, component, attributes, -1);
            return;
        }
        if (value instanceof MemoryPointer) {
            Render.render((MemoryPointer)value, component, attributes);
            return;
        }
        if (value instanceof MemoryRange) {
            Render.render((MemoryRange)value, component, attributes);
            return;
        }
        component.append(value.toString(), attributes);
    }

    public static void render(@NotNull Dynamic dynamic, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (dynamic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dynamic", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        MemoryPointer mp = Render.tryMemoryPointer(dynamic);
        if (mp != null) {
            Render.render(mp, component, attributes);
            return;
        }
        component.append("{", SimpleTextAttributes.GRAY_ATTRIBUTES);
        for (int index = 0; index < dynamic.getFieldCount(); ++index) {
            if (index > 0) {
                component.append(",", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            Render.render(dynamic.getFieldValue(index), dynamic.getFieldInfo(index).getType(), component, attributes);
        }
        component.append("}", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    private static MemoryPointer tryMemoryPointer(Dynamic dynamic) {
        Entity entity = dynamic.klass().entity();
        Field[] fields = entity.getFields();
        MemoryPointer mp = new MemoryPointer();
        Field[] mpFields = mp.klass().entity().getFields();
        if (mpFields.length != fields.length || entity.getMetadata().length != 0) {
            return null;
        }
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].equals((Object)mpFields[i])) continue;
            return null;
        }
        long address = (Long)dynamic.getFieldValue(0);
        PoolID poolId = PoolID.findOrCreate(((Number)dynamic.getFieldValue(1)).intValue());
        mp.setAddress(address);
        mp.setPool(poolId);
        return mp;
    }

    public static void render(@NotNull Field field, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        component.append(field.getName(), attributes);
    }

    public static void render(@NotNull StateController.Node node, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (node.key.type != null) {
            Render.render(node.key.value, node.key.type, component, attributes);
        } else {
            component.append(String.valueOf(node.key.value), attributes);
        }
        if (node.isLeaf() && node.value != null && node.value.value != null) {
            component.append(": ", attributes);
            Render.render(node.value.value, node.value.type, component, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
        }
    }

    public static void render(@NotNull AtomController.Node node, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        Render.render(node.index, component, attributes);
        if (node.atom != null) {
            component.append(": ", attributes);
            if (node.atom instanceof DynamicAtom) {
                Render.render((DynamicAtom)node.atom, component, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES, node.hoveredParameter);
            } else {
                Render.render(node.atom, component, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
            }
        }
    }

    public static void render(@NotNull AtomController.Memory memory, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (memory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memory", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        Render.render(memory.isRead ? "read:" : "write:", component, attributes);
        Render.render(memory.observation.getRange(), component, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
    }

    public static void render(@NotNull AtomController.Group group, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        component.append(group.group.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
    }

    public static void render(@NotNull DynamicAtom atom, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, int highlightedParameter) {
        if (atom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atom", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        component.append(atom.getName() + "(", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, (Object)-1);
        int resultIndex = atom.getResultIndex();
        int extrasIndex = atom.getExtrasIndex();
        boolean needComma = false;
        for (int i = 0; i < atom.getFieldCount(); ++i) {
            if (i == resultIndex || i == extrasIndex) continue;
            Field field = atom.getFieldInfo(i);
            if (needComma) {
                component.append(", ", SimpleTextAttributes.REGULAR_ATTRIBUTES, (Object)-1);
            }
            needComma = true;
            Object parameterValue = atom.getFieldValue(i);
            component.append(field.getDeclared() + ":", i == highlightedParameter ? SimpleTextAttributes.LINK_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES, (Object)i);
            Render.render(parameterValue, field.getType(), component, i == highlightedParameter ? SimpleTextAttributes.LINK_ATTRIBUTES : attributes);
        }
        component.append(")", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, (Object)-1);
        if (resultIndex >= 0) {
            component.append("->", resultIndex == highlightedParameter ? SimpleTextAttributes.LINK_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES, (Object)resultIndex);
            Field field = atom.getFieldInfo(resultIndex);
            Object parameterValue = atom.getFieldValue(resultIndex);
            Render.render(parameterValue, field.getType(), component, attributes);
        }
    }

    public static void render(@NotNull MemoryPointer pointer, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        component.append("0x" + Long.toHexString(pointer.getAddress()), attributes);
        if (!PoolID.ApplicationPool.equals(pointer.getPool())) {
            component.append("@", SimpleTextAttributes.GRAY_ATTRIBUTES);
            component.append(pointer.getPool().toString(), attributes);
        }
    }

    public static void render(@NotNull MemoryRange range, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        component.append(Long.toString(range.getSize()), attributes);
        component.append(" bytes at ", SimpleTextAttributes.GRAY_ATTRIBUTES);
        component.append("0x" + Long.toHexString(range.getBase()), attributes);
    }

    public static void render(@NotNull Object value, @NotNull Type type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type instanceof Primitive) {
            Render.render(value, (Primitive)type, component, attributes);
            return;
        }
        if (type instanceof Struct) {
            Render.render(value, (Struct)type, component, attributes);
            return;
        }
        if (type instanceof Pointer) {
            Render.render(value, (Pointer)type, component, attributes);
            return;
        }
        if (type instanceof Interface) {
            Render.render(value, (Interface)type, component, attributes);
            return;
        }
        if (type instanceof Array) {
            Render.render(value, (Array)type, component, attributes);
            return;
        }
        if (type instanceof Slice) {
            Render.render(value, (Slice)type, component, attributes);
            return;
        }
        if (type instanceof Map) {
            Render.render(value, (Map)type, component, attributes);
            return;
        }
        if (type instanceof AnyType) {
            Render.render(value, (AnyType)type, component, attributes);
            return;
        }
        Render.render(value, component, attributes);
    }

    public static void render(@NotNull Object value, @NotNull Struct type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        Render.render(value, component, attributes);
    }

    public static void render(@NotNull Object value, @NotNull Pointer type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        component.append("*", SimpleTextAttributes.GRAY_ATTRIBUTES);
        Render.render(value, component, attributes);
    }

    public static void render(@NotNull Object value, @NotNull Interface type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        component.append("$", SimpleTextAttributes.GRAY_ATTRIBUTES);
        Render.render(value, component, attributes);
    }

    public static void render(@NotNull Object value, @NotNull Array type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        assert (value instanceof Object[]);
        Render.render((Object[])value, type.getValueType(), component, attributes);
    }

    public static void render(@NotNull Object value, @NotNull Slice type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (value instanceof Object[]) {
            Render.render((Object[])value, type.getValueType(), component, attributes);
        } else if (value instanceof byte[]) {
            Render.render((byte[])value, type.getValueType(), component, attributes);
        } else assert (false);
    }

    public static void render(@NotNull Object value, @NotNull Map type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        Render.render(value, component, attributes);
    }

    public static void render(@NotNull Object value, @NotNull AnyType type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        Render.render(value, component, attributes);
    }

    private static Constant pickShortestName(List<Constant> constants) {
        int len = Integer.MAX_VALUE;
        Constant shortest = null;
        for (Constant constant : constants) {
            int l = constant.getName().length();
            if (l >= len) continue;
            len = l;
            shortest = constant;
        }
        return shortest;
    }

    public static void render(@NotNull Object value, @NotNull Primitive type, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        List byValue;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        ConstantSet constants = ConstantSet.lookup((Type)type);
        if (constants != null && constants.getEntries().length != 0 && (byValue = constants.getByValue(value)) != null && byValue.size() != 0 && byValue.size() < 8) {
            component.append(Render.pickShortestName(byValue).getName(), attributes);
            return;
        }
        switch (type.getMethod().getValue()) {
            case 0: {
                component.append(String.format("%b", (Boolean)value), attributes);
                return;
            }
            case 1: {
                component.append(String.format("%d", ((Number)value).byteValue()), attributes);
                return;
            }
            case 2: {
                component.append(String.format("%d", ((Number)value).intValue() & 0xFF), attributes);
                return;
            }
            case 3: {
                component.append(String.format("%d", ((Number)value).shortValue()), attributes);
                return;
            }
            case 4: {
                component.append(String.format("%d", ((Number)value).intValue() & 0xFFFF), attributes);
                return;
            }
            case 5: {
                component.append(String.format("%d", ((Number)value).intValue()), attributes);
                return;
            }
            case 6: {
                component.append(String.format("%d", ((Number)value).longValue() & 0xFFFFFFFFL), attributes);
                return;
            }
            case 7: {
                component.append(String.format("%d", ((Number)value).longValue()), attributes);
                return;
            }
            case 8: {
                component.append(String.format("0x%s", Long.toHexString(((Number)value).longValue())), attributes);
                return;
            }
            case 9: {
                component.append(String.format("%f", Float.valueOf(((Number)value).floatValue())), attributes);
                return;
            }
            case 10: {
                component.append(String.format("%f", ((Number)value).doubleValue()), attributes);
                return;
            }
            case 11: {
                component.append(String.valueOf(value), attributes);
                return;
            }
        }
        component.append(value.toString(), attributes);
    }

    public static void render(@NotNull Object[] array, @NotNull Type valueType, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (valueType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueType", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        int count = Math.min(array.length, 3);
        component.append("[", SimpleTextAttributes.GRAY_ATTRIBUTES);
        for (int index = 0; index < count; ++index) {
            if (index > 0) {
                component.append(",", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            Render.render(array[index], valueType, component, attributes);
        }
        if (count < array.length) {
            component.append("...", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public static void render(@NotNull byte[] array, @NotNull Type valueType, @NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (valueType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueType", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        int count = Math.min(array.length, 3);
        component.append("[", SimpleTextAttributes.GRAY_ATTRIBUTES);
        for (int index = 0; index < count; ++index) {
            if (index > 0) {
                component.append(",", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            Render.render((Object)array[index], valueType, component, attributes);
        }
        if (count < array.length) {
            component.append("...", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public static int getAtomParameterIndex(@NotNull SimpleColoredComponent component, int x) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "getAtomParameterIndex"));
        }
        for (int index = component.findFragmentAt(x); index >= 2; --index) {
            Object tag = component.getFragmentTag(index);
            if (tag == null || !(tag instanceof Integer)) continue;
            return (Integer)tag;
        }
        return -1;
    }
}

