/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.hprof.HprofView;
import com.android.tools.idea.editors.hprof.views.HprofAnalysisContentsDelegate;
import com.android.tools.idea.profiling.view.CaptureEditor;
import com.android.tools.idea.profiling.view.CapturePanel;
import com.android.tools.perflib.analyzer.AnalysisReport;
import com.android.tools.perflib.analyzer.AnalyzerTask;
import com.android.tools.perflib.analyzer.Capture;
import com.android.tools.perflib.analyzer.CaptureGroup;
import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.captures.MemoryMappedFileBuffer;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.analysis.ComputationProgress;
import com.android.tools.perflib.heap.memoryanalyzer.DuplicatedStringsAnalyzerTask;
import com.android.tools.perflib.heap.memoryanalyzer.LeakedActivityAnalyzerTask;
import com.android.tools.perflib.heap.memoryanalyzer.MemoryAnalyzer;
import com.google.common.base.Throwables;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HprofEditor
extends CaptureEditor {
    @NotNull
    private static final Logger LOG = Logger.getInstance(HprofEditor.class);
    @Nullable
    private HprofView myView;
    private Snapshot mySnapshot;
    private boolean myIsValid;

    public HprofEditor(final @NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/hprof/HprofEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/hprof/HprofEditor", "<init>"));
        }
        this.myIsValid = true;
        AnalyzerTask[] tasks = new AnalyzerTask[]{new LeakedActivityAnalyzerTask(), new DuplicatedStringsAnalyzerTask()};
        this.myPanel = new CapturePanel(project, this, tasks, true);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File hprofFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                final InlineProgressIndicator indicator = HprofEditor.this.myPanel.getProgressIndicator();
                assert (indicator != null);
                Timer timer = null;
                try {
                    HprofEditor.updateIndicator(indicator, 0.01, "Parsing hprof file...");
                    HprofEditor.this.mySnapshot = Snapshot.createSnapshot((DataBuffer)new MemoryMappedFileBuffer(hprofFile));
                    timer = new Timer(33, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            Snapshot.DominatorComputationStage stage = HprofEditor.this.mySnapshot.getDominatorComputationStage();
                            ComputationProgress progress = HprofEditor.this.mySnapshot.getComputationProgress();
                            HprofEditor.updateIndicator(indicator, Snapshot.DominatorComputationStage.toAbsoluteProgressPercentage((Snapshot.DominatorComputationStage)stage, (ComputationProgress)progress), progress.getMessage());
                        }
                    });
                    timer.start();
                    HprofEditor.this.mySnapshot.computeDominators();
                }
                catch (Throwable throwable) {
                    LOG.info(throwable);
                    final String errorMessage = "Unexpected error while processing hprof file: " + Throwables.getRootCause((Throwable)throwable).getMessage();
                    indicator.cancel();
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)project, (String)errorMessage, (String)HprofEditor.this.getName());
                        }
                    });
                }
                finally {
                    if (timer != null) {
                        timer.stop();
                    }
                    if (HprofEditor.this.mySnapshot != null) {
                        HprofEditor.this.myView = new HprofView(project, HprofEditor.this, HprofEditor.this.mySnapshot);
                        HprofAnalysisContentsDelegate delegate = new HprofAnalysisContentsDelegate(HprofEditor.this);
                        HprofEditor.this.myPanel.setEditorPanel(HprofEditor.this.myView.getComponent(), delegate);
                        Disposer.register((Disposable)HprofEditor.this, (Disposable)HprofEditor.this.myView);
                        Disposer.register((Disposable)HprofEditor.this, (Disposable)delegate);
                    }
                }
            }
        });
    }

    @Nullable
    public HprofView getView() {
        return this.myView;
    }

    @NotNull
    public JComponent getComponent() {
        CapturePanel capturePanel = this.myPanel;
        if (capturePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/HprofEditor", "getComponent"));
        }
        return capturePanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        if ("HprofView" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/HprofEditor", "getName"));
        }
        return "HprofView";
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/hprof/HprofEditor", "setState"));
        }
    }

    public boolean isModified() {
        return false;
    }

    public void setInvalid() {
        this.myIsValid = false;
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/hprof/HprofEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/hprof/HprofEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        this.mySnapshot.dispose();
        this.mySnapshot = null;
        this.myPanel = null;
        this.myIsValid = false;
    }

    @Override
    @NotNull
    public DesignerEditorPanelFacade getFacade() {
        CapturePanel capturePanel = this.myPanel;
        if (capturePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/HprofEditor", "getFacade"));
        }
        return capturePanel;
    }

    @Override
    @NotNull
    public AnalysisReport performAnalysis(@NotNull Set<? extends AnalyzerTask> tasks, @NotNull Set<AnalysisReport.Listener> listeners) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/android/tools/idea/editors/hprof/HprofEditor", "performAnalysis"));
        }
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "com/android/tools/idea/editors/hprof/HprofEditor", "performAnalysis"));
        }
        assert (this.mySnapshot != null);
        CaptureGroup captureGroup = new CaptureGroup();
        captureGroup.addCapture((Capture)this.mySnapshot);
        MemoryAnalyzer memoryAnalyzer = new MemoryAnalyzer();
        assert (memoryAnalyzer.accept(captureGroup));
        AnalysisReport analysisReport = memoryAnalyzer.analyze(captureGroup, listeners, tasks, (Executor)EdtExecutor.INSTANCE, Executors.newSingleThreadExecutor());
        if (analysisReport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/HprofEditor", "performAnalysis"));
        }
        return analysisReport;
    }

    /*
     * WARNING - void declaration
     */
    private static void updateIndicator(final @NotNull InlineProgressIndicator indicator, final double fraction, @NotNull String string) {
        void text;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/editors/hprof/HprofEditor", "updateIndicator"));
        }
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/editors/hprof/HprofEditor", "updateIndicator"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable((String)text){
            final /* synthetic */ String val$text;
            {
                this.val$text = string;
            }

            @Override
            public void run() {
                indicator.setFraction(fraction);
                indicator.setText(this.val$text);
            }
        });
    }
}

