/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.macros;

import com.android.tools.idea.editors.navigation.Listener;
import com.android.tools.idea.editors.navigation.NavigationEditorUtils;
import com.android.tools.idea.editors.navigation.model.ActivityState;
import com.android.tools.idea.editors.navigation.model.Locator;
import com.android.tools.idea.editors.navigation.model.MenuState;
import com.android.tools.idea.editors.navigation.model.State;
import com.android.tools.idea.editors.navigation.model.Transition;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;

public class CodeGenerator {
    private static final Logger LOG = Logger.getInstance((String)CodeGenerator.class.getName());
    private static final String[] FRAMEWORK_IMPORTS = new String[]{"android.content.Intent"};
    public static final String TRANSITION_ADDED = "Transition added";
    private static final String LIST_POSITION_EXTRA_NAME = "position";
    private static final boolean PREPEND_PACKAGE_NAME_TO_EXTRA_NAME = false;
    private static final Template SHOW_MENU = new Template(){
        {
            this.imports = new String[]{"android.view.Menu"};
            this.signature = "boolean onCreateOptionsMenu(Menu menu)";
            this.body = "@Override public boolean onCreateOptionsMenu(Menu menu) {     return true;}";
            this.insertCodeBeforeLastStatement = true;
            this.code = new Function<Transition, String>(){

                public String fun(Transition transition) {
                    String destinationResourceName = ((MenuState)transition.getDestination().getState()).getXmlResourceName();
                    return "getMenuInflater().inflate(R.menu." + destinationResourceName + ", $0);";
                }
            };
        }
    };
    private static final Template MENU_ACTION = new Template(){
        {
            this.imports = new String[]{"android.view.Menu", "android.view.MenuItem"};
            this.signature = "boolean onPrepareOptionsMenu(Menu menu)";
            this.body = "@Override public boolean onPrepareOptionsMenu(Menu menu) {     boolean result = super.onPrepareOptionsMenu(menu);     return result;}";
            this.insertCodeBeforeLastStatement = true;
            this.code = new Function<Transition, String>(){

                public String fun(Transition transition) {
                    Locator source = transition.getSource();
                    String viewName = source.getViewId();
                    String sourceClassName = source.getState().getClassName();
                    String destinationClassName = transition.getDestination().getState().getClassName();
                    String activity = sourceClassName + ".this";
                    return "$0.findItem(R.id." + viewName + ").setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener() {    @Override    public boolean onMenuItemClick(MenuItem menuItem) {        startActivity(new Intent(" + activity + ", " + destinationClassName + ".class));        return true;    }});";
                }
            };
        }
    };
    public final Module module;
    public final Listener<String> listener;

    private static Template setOnClickListener(final boolean isFragment) {
        return new Template(){
            {
                this.imports = new String[]{"android.view.View", "android.os.Bundle"};
                this.signature = isFragment ? "void onViewCreated(View view, Bundle savedInstanceState)" : "void onCreate(Bundle savedInstanceState)";
                this.body = "@Override\npublic " + this.signature + " {     super.onCreate(savedInstanceState);}";
                this.insertCodeBeforeLastStatement = false;
                this.code = new Function<Transition, String>(){

                    public String fun(Transition transition) {
                        Locator source = transition.getSource();
                        String viewName = source.getViewId();
                        String sourceClassName = source.getState().getClassName();
                        Locator destination = transition.getDestination();
                        String destinationClassName = destination.getState().getClassName();
                        String finder = isFragment ? "view." : "";
                        String activity = isFragment ? "getActivity()" : sourceClassName + ".this";
                        return finder + "findViewById(R.id." + viewName + ").setOnClickListener(new View.OnClickListener() {     @Override    public void onClick(View v) {        startActivity(new Intent(" + activity + ", " + destinationClassName + ".class));    }});";
                    }
                };
            }
        };
    }

    private static Template overrideOnItemClickInList(final boolean isFragment) {
        return new Template(){
            {
                this.imports = new String[]{"android.view.View", "android.widget.ListView"};
                this.signature = "void onListItemClick(ListView l, View v, int position, long id)";
                this.body = "@Override\n" + (isFragment ? "public" : "protected") + " " + this.signature + " {    super.onListItemClick(l, v, position, id);\n}";
                this.insertCodeBeforeLastStatement = false;
                this.code = new Function<Transition, String>(){

                    public String fun(Transition transition) {
                        Locator source = transition.getSource();
                        String sourceClassName = source.getState().getClassName();
                        String sourcePackageName = sourceClassName.substring(0, sourceClassName.lastIndexOf(46));
                        Locator destination = transition.getDestination();
                        String destinationClassName = destination.getState().getClassName();
                        String activity = isFragment ? "getActivity()" : sourceClassName + ".this";
                        return "startActivity(new Intent(" + activity + ", " + destinationClassName + ".class).putExtra(\"" + CodeGenerator.LIST_POSITION_EXTRA_NAME + "\", position));";
                    }
                };
            }
        };
    }

    public CodeGenerator(Module module, Listener<String> listener) {
        this.module = module;
        this.listener = listener;
    }

    private static void addImports(Module module, ImportHelper importHelper, PsiJavaFile file, String[] classNames) {
        for (String className : classNames) {
            PsiClass psiClass = NavigationEditorUtils.getPsiClass(module, className);
            if (psiClass != null) {
                importHelper.addImport(file, psiClass);
                continue;
            }
            LOG.warn("Class not found: " + className);
        }
    }

    private static void addImportsAsNecessary(Module module, PsiClass psiClass, String ... classNames) {
        PsiJavaFile file = (PsiJavaFile)psiClass.getContainingFile();
        ImportHelper importHelper = new ImportHelper(CodeStyleSettingsManager.getSettings((Project)module.getProject()));
        CodeGenerator.addImports(module, importHelper, file, FRAMEWORK_IMPORTS);
        CodeGenerator.addImports(module, importHelper, file, classNames);
    }

    private void notifyListeners(PsiClass psiClass) {
        this.listener.notify(TRANSITION_ADDED);
    }

    private CodeStyleManager getCodeStyleManager() {
        return CodeStyleManager.getInstance((Project)this.module.getProject());
    }

    private static String substituteArgs(PsiMethod method, String code) {
        if (code.contains("$0")) {
            code = code.replace("$0", method.getParameterList().getParameters()[0].getName());
        }
        return code;
    }

    private WriteCommandAction<Void> createAddCodeAction(final PsiClass psiClass, final String signatureText, final String templateText, final String codeToInsert, final boolean addBeforeLastStatement, final String ... imports) {
        final PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.module.getProject()).getElementFactory();
        return new WriteCommandAction<Void>(this.module.getProject(), "Add navigation transition", new PsiFile[]{psiClass.getContainingFile()}){

            protected void run(@NotNull Result<Void> result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/editors/navigation/macros/CodeGenerator$5", "run"));
                }
                PsiMethod signature = factory.createMethodFromText(signatureText + "{}", (PsiElement)psiClass);
                PsiMethod method = psiClass.findMethodBySignature(signature, false);
                if (method == null) {
                    method = factory.createMethodFromText(templateText, (PsiElement)psiClass);
                    psiClass.add((PsiElement)method);
                    method = psiClass.findMethodBySignature(signature, false);
                    assert (method != null);
                }
                PsiCodeBlock body = method.getBody();
                assert (body != null);
                PsiStatement[] statements = body.getStatements();
                PsiStatement lastStatement = statements[statements.length - 1];
                PsiStatement newStatement = factory.createStatementFromText(CodeGenerator.substituteArgs(method, codeToInsert), (PsiElement)body);
                if (addBeforeLastStatement) {
                    body.addBefore((PsiElement)newStatement, (PsiElement)lastStatement);
                } else {
                    body.addAfter((PsiElement)newStatement, (PsiElement)lastStatement);
                }
                CodeGenerator.addImportsAsNecessary(CodeGenerator.this.module, psiClass, imports);
                CodeGenerator.this.getCodeStyleManager().reformat((PsiElement)method);
                CodeGenerator.this.notifyListeners(psiClass);
            }
        };
    }

    private WriteCommandAction<Void> createAddCodeAction(PsiClass psiClass, Template template, Transition t) {
        return this.createAddCodeAction(psiClass, template.signature, template.body, (String)template.code.fun((Object)t), template.insertCodeBeforeLastStatement, template.imports);
    }

    public void implementTransition(final Transition transition) {
        Locator source = transition.getSource();
        State sourceState = source.getState();
        String fragmentClassName = source.getFragmentClassName();
        final boolean targetIsFragment = fragmentClassName != null;
        String targetClassName = targetIsFragment ? fragmentClassName : sourceState.getClassName();
        final PsiClass hostClass = NavigationEditorUtils.getPsiClass(this.module, targetClassName);
        if (hostClass == null) {
            return;
        }
        final State destinationState = transition.getDestination().getState();
        sourceState.accept(new State.Visitor(){

            @Override
            public void visit(ActivityState sourceState) {
                destinationState.accept(new State.Visitor(){

                    @Override
                    public void visit(ActivityState destinationState) {
                        PsiClass listClass = NavigationEditorUtils.getPsiClass(CodeGenerator.this.module, targetIsFragment ? "android.app.ListFragment" : "android.app.ListActivity");
                        assert (listClass != null);
                        Template t = hostClass.isInheritor(listClass, true) ? CodeGenerator.overrideOnItemClickInList(targetIsFragment) : CodeGenerator.setOnClickListener(targetIsFragment);
                        t.installTransition(CodeGenerator.this, hostClass, transition);
                    }

                    @Override
                    public void visit(MenuState destinationState) {
                        SHOW_MENU.installTransition(CodeGenerator.this, hostClass, transition);
                    }
                });
            }

            @Override
            public void visit(MenuState sourceState) {
                destinationState.accept(new State.BaseVisitor(){

                    @Override
                    public void visit(ActivityState destinationState) {
                        MENU_ACTION.installTransition(CodeGenerator.this, hostClass, transition);
                    }
                });
            }
        });
    }

    private static class Template {
        public String[] imports;
        public String signature;
        public String body;
        public boolean insertCodeBeforeLastStatement;
        public Function<Transition, String> code;

        private Template() {
        }

        private void installTransition(CodeGenerator codeGenerator, PsiClass psiClass, Transition transition) {
            codeGenerator.createAddCodeAction(psiClass, this, transition).execute();
        }
    }
}

