/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.editors.theme.ThemeEditor;
import com.android.tools.idea.editors.theme.ThemeEditorState;
import com.android.tools.idea.editors.theme.ThemeEditorVirtualFile;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.stats.UsageTracker;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorProvider
implements FileEditorProvider,
DumbAware {
    public static final boolean THEME_EDITOR_ENABLE = true;
    private static final String THEME_NAME = "theme-name";
    private static final String STYLE_NAME = "style-name";
    private static final String MODULE_NAME = "module-name";
    private static final String PROPORTION = "proportion";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/theme/ThemeEditorProvider", "accept"));
        }
        return file instanceof ThemeEditorVirtualFile;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/theme/ThemeEditorProvider", "createEditor"));
        }
        UsageTracker.getInstance().trackEvent("themeEditor", "themeEditorOpened", null, null);
        ThemeEditor themeEditor = new ThemeEditor(project, file);
        if (themeEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorProvider", "createEditor"));
        }
        return themeEditor;
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/android/tools/idea/editors/theme/ThemeEditorProvider", "readState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorProvider", "readState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/theme/ThemeEditorProvider", "readState"));
        }
        String themeName = sourceElement.getAttributeValue(THEME_NAME);
        String styleName = sourceElement.getAttributeValue(STYLE_NAME);
        String moduleName = sourceElement.getAttributeValue(MODULE_NAME);
        Float proportion = null;
        try {
            String proportionString = sourceElement.getAttributeValue(PROPORTION);
            if (proportionString != null) {
                proportion = Float.valueOf(Float.parseFloat(proportionString));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ThemeEditorState themeEditorState = new ThemeEditorState(themeName, styleName, proportion, moduleName);
        if (themeEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorProvider", "readState"));
        }
        return themeEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/theme/ThemeEditorProvider", "writeState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorProvider", "writeState"));
        }
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "com/android/tools/idea/editors/theme/ThemeEditorProvider", "writeState"));
        }
        if (!(state instanceof ThemeEditorState)) {
            return;
        }
        ThemeEditorState editorState = (ThemeEditorState)state;
        ThemeEditorProvider.setAttributeIfNotNull(targetElement, THEME_NAME, editorState.getThemeName());
        ThemeEditorProvider.setAttributeIfNotNull(targetElement, STYLE_NAME, editorState.getSubStyleName());
        ThemeEditorProvider.setAttributeIfNotNull(targetElement, MODULE_NAME, editorState.getModuleName());
        targetElement.setAttribute(PROPORTION, Float.toString(editorState.getProportion()));
    }

    private static void setAttributeIfNotNull(@NotNull Element targetElement, String paramName, String paramValue) {
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "com/android/tools/idea/editors/theme/ThemeEditorProvider", "setAttributeIfNotNull"));
        }
        if (paramValue != null) {
            targetElement.setAttribute(paramName, paramValue);
        }
    }

    @NotNull
    public String getEditorTypeId() {
        if ("themeEditor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorProvider", "getEditorTypeId"));
        }
        return "themeEditor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }

    public static boolean isAndroidTheme(@Nullable PsiFile file) {
        if (ResourceHelper.getFolderType(file) != ResourceFolderType.VALUES || !(file instanceof XmlFile)) {
            return false;
        }
        String name = file.getName();
        if (name.equals("strings.xml")) {
            return false;
        }
        if (name.equals("styles.xml")) {
            return true;
        }
        XmlTag rootTag = ((XmlFile)file).getRootTag();
        if (rootTag == null || !rootTag.getName().equals("resources")) {
            return false;
        }
        for (XmlTag child : rootTag.getSubTags()) {
            if (!child.getName().equals("style")) continue;
            return true;
        }
        return false;
    }
}

