/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.tools.fd.client.UpdateMode;
import com.android.tools.fd.client.UserFeedback;
import com.android.tools.idea.fd.InstantRunConfigurable;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.actions.RestartActivityAction;
import com.google.common.html.HtmlEscapers;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import javax.swing.event.HyperlinkEvent;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunUserFeedback
implements UserFeedback {
    @Language(value="HTML")
    public static String LEARN_MORE_LINK = " <a href=\"http://developer.android.com/r/studio-ui/instant-run.html\">Learn More</a>.";
    @NotNull
    private final Module myModule;

    public InstantRunUserFeedback(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/InstantRunUserFeedback", "<init>"));
        }
        this.myModule = module;
    }

    public void error(String message) {
        this.postText(NotificationType.ERROR, message);
    }

    public void warning(String message) {
        this.postText(NotificationType.WARNING, message);
    }

    public void info(String message) {
        this.postText(NotificationType.INFORMATION, message);
    }

    public void noChanges() {
        this.postText(NotificationType.INFORMATION, "No Changes.");
    }

    public void notifyEnd(UpdateMode updateMode) {
        if (updateMode == UpdateMode.HOT_SWAP && !InstantRunSettings.isRestartActivity()) {
            StringBuilder sb = new StringBuilder(300);
            sb.append("Instant Run applied code changes.\n");
            sb.append("You may need to <a href=\"restart\">restart</a>");
            Shortcut[] shortcuts = ActionManager.getInstance().getAction("Android.RestartActivity").getShortcutSet().getShortcuts();
            if (shortcuts.length > 0) {
                String shortcut = KeymapUtil.getShortcutText((Shortcut)shortcuts[0]);
                sb.append(" ( ").append(shortcut).append(" )");
            }
            sb.append(" the current activity to see the changes.\n");
            sb.append("You can also <a href=\"configure\">configure</a> Instant Run to restart Activities automatically.");
            String message = sb.toString();
            NotificationListener listener = new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/fd/InstantRunUserFeedback$1", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/fd/InstantRunUserFeedback$1", "hyperlinkUpdate"));
                    }
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        String action = event.getDescription();
                        if ("restart".equals(action)) {
                            RestartActivityAction.restartActivity(InstantRunUserFeedback.this.myModule);
                        } else if ("configure".equals(action)) {
                            InstantRunConfigurable configurable = new InstantRunConfigurable();
                            ShowSettingsUtil.getInstance().editConfigurable(InstantRunUserFeedback.this.myModule.getProject(), (Configurable)configurable);
                        } else assert (false) : action;
                    }
                }
            };
            this.postHtml(NotificationType.INFORMATION, message, listener);
        } else if (updateMode == UpdateMode.WARM_SWAP) {
            String message = "Instant Run applied code changes and restarted the current Activity.";
            this.postHtml(NotificationType.INFORMATION, message, null);
        }
    }

    public void verifierFailure(@Language(value="HTML") String htmlMessage) {
        this.postHtml(NotificationType.INFORMATION, htmlMessage, null);
    }

    public void notifyDisabledForLaunch(@Language(value="HTML") @NotNull String reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/android/tools/idea/fd/InstantRunUserFeedback", "notifyDisabledForLaunch"));
        }
        this.postHtml(NotificationType.INFORMATION, reason, null);
    }

    public void postText(@NotNull NotificationType type, @NotNull String message) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/fd/InstantRunUserFeedback", "postText"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/fd/InstantRunUserFeedback", "postText"));
        }
        this.postHtml(type, HtmlEscapers.htmlEscaper().escape(message), null);
    }

    public void postHtml(@NotNull NotificationType type, @Language(value="HTML") @NotNull String htmlMessage, final @Nullable NotificationListener listener) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/fd/InstantRunUserFeedback", "postHtml"));
        }
        if (htmlMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlMessage", "com/android/tools/idea/fd/InstantRunUserFeedback", "postHtml"));
        }
        if (!InstantRunSettings.isShowNotificationsEnabled()) {
            return;
        }
        NotificationGroup group = InstantRunManager.NOTIFICATION_GROUP;
        String message = "<html>" + htmlMessage + "<br/>(<a href=\"mute\">Don't show again</a>)</html>";
        NotificationListener l = new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/fd/InstantRunUserFeedback$2", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/fd/InstantRunUserFeedback$2", "hyperlinkUpdate"));
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String description = event.getDescription();
                    if (description != null && description.startsWith("http")) {
                        BrowserUtil.browse((String)description);
                    } else if ("mute".equals(description)) {
                        InstantRunSettings.setShowStatusNotifications(false);
                    } else if (listener != null) {
                        listener.hyperlinkUpdate(notification, event);
                    }
                }
            }
        };
        Notification notification = group.createNotification("", message, type, l);
        notification.notify(this.myModule.getProject());
    }
}

