/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd.actions;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.fd.client.InstantRunPushFailedException;
import com.android.tools.fd.client.UpdateMode;
import com.android.tools.idea.fd.InstantRunGradleUtils;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.InstantRunUserFeedback;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import icons.AndroidIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunWithoutRestart
extends AnAction {
    public InstantRunWithoutRestart() {
        this("Perform Instant Run", AndroidIcons.RunIcons.Replay);
    }

    protected InstantRunWithoutRestart(String title, @NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/fd/actions/InstantRunWithoutRestart", "<init>"));
        }
        super(title, null, icon);
    }

    public void update(AnActionEvent e) {
        super.update(e);
    }

    public void actionPerformed(AnActionEvent e) {
        Module module = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        if (module == null) {
            return;
        }
        this.perform(module);
    }

    private void perform(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/actions/InstantRunWithoutRestart", "perform"));
        }
        if (!InstantRunSettings.isInstantRunEnabled()) {
            return;
        }
        Project project = module.getProject();
        List<IDevice> devices = InstantRunManager.findDevices(project);
        InstantRunManager manager = InstantRunManager.get(project);
        for (IDevice device : devices) {
            if (!InstantRunGradleUtils.getIrSupportStatus((Module)module, (AndroidVersion)device.getVersion()).success || !InstantRunManager.isAppInForeground(device, module)) continue;
            if (InstantRunManager.buildTimestampsMatch(device, module)) {
                InstantRunWithoutRestart.performUpdate(manager, device, this.getUpdateMode(), module, project);
                break;
            }
            new InstantRunUserFeedback(module).postText(NotificationType.INFORMATION, "Local Gradle build id doesn't match what's installed on the device; full build required");
            break;
        }
    }

    private static void performUpdate(@NotNull InstantRunManager manager, @NotNull IDevice device, @NotNull UpdateMode updateMode, @Nullable Module module, @NotNull Project project) {
        AndroidGradleModel model;
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/fd/actions/InstantRunWithoutRestart", "performUpdate"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/actions/InstantRunWithoutRestart", "performUpdate"));
        }
        if (updateMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateMode", "com/android/tools/idea/fd/actions/InstantRunWithoutRestart", "performUpdate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/actions/InstantRunWithoutRestart", "performUpdate"));
        }
        AndroidFacet facet = InstantRunGradleUtils.findAppModule(module, project);
        if (facet != null && (model = AndroidGradleModel.get(facet)) != null) {
            InstantRunWithoutRestart.runGradle(manager, device, model, facet, updateMode);
        }
    }

    private static void runGradle(final @NotNull InstantRunManager manager, final @NotNull IDevice device, final @NotNull AndroidGradleModel model, final @NotNull AndroidFacet facet, final @NotNull UpdateMode updateMode) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/fd/actions/InstantRunWithoutRestart", "runGradle"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/actions/InstantRunWithoutRestart", "runGradle"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/fd/actions/InstantRunWithoutRestart", "runGradle"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/fd/actions/InstantRunWithoutRestart", "runGradle"));
        }
        if (updateMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateMode", "com/android/tools/idea/fd/actions/InstantRunWithoutRestart", "runGradle"));
        }
        Project project = facet.getModule().getProject();
        final GradleInvoker invoker = GradleInvoker.getInstance(project);
        final Ref reference = Ref.create();
        GradleInvoker.AfterGradleInvocationTask task = new GradleInvoker.AfterGradleInvocationTask(){

            @Override
            public void execute(@NotNull GradleInvocationResult result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/fd/actions/InstantRunWithoutRestart$1", "execute"));
                }
                invoker.removeAfterGradleInvocationTask((GradleInvoker.AfterGradleInvocationTask)reference.get());
                InstantRunBuildInfo buildInfo = InstantRunGradleUtils.getBuildInfo(model);
                if (buildInfo != null) {
                    try {
                        manager.pushArtifacts(device, facet, updateMode, buildInfo);
                    }
                    catch (InstantRunPushFailedException e) {
                        Logger.getInstance(InstantRunWithoutRestart.class).warn((Throwable)e);
                    }
                }
            }
        };
        reference.set((Object)task);
        invoker.addAfterGradleInvocationTask(task);
        String taskName = InstantRunGradleUtils.getIncrementalDexTask(model, facet.getModule());
        invoker.executeTasks(Collections.singletonList(taskName));
    }

    @NotNull
    protected UpdateMode getUpdateMode() {
        UpdateMode updateMode = UpdateMode.HOT_SWAP;
        if (updateMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/actions/InstantRunWithoutRestart", "getUpdateMode"));
        }
        return updateMode;
    }
}

