/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.tools.idea.gradle.facet.NativeAndroidGradleFacet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAndroidGradleModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final ProjectSystemId myProjectSystemId;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final File myRootDirPath;
    @NotNull
    private final NativeAndroidProject myNativeAndroidProject;
    @NotNull
    private final Map<String, NativeVariant> myVariantsByName;
    @NotNull
    private final Map<String, NativeToolchain> myToolchainsByName;
    @NotNull
    private final Map<String, NativeSettings> mySettingsByName;
    @NotNull
    private String mySelectedVariantName;

    @Nullable
    public static NativeAndroidGradleModel get(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/NativeAndroidGradleModel", "get"));
        }
        NativeAndroidGradleFacet facet = NativeAndroidGradleFacet.getInstance(module);
        return facet != null ? NativeAndroidGradleModel.get(facet) : null;
    }

    @Nullable
    public static NativeAndroidGradleModel get(@NotNull NativeAndroidGradleFacet androidFacet) {
        if (androidFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidFacet", "com/android/tools/idea/gradle/NativeAndroidGradleModel", "get"));
        }
        NativeAndroidGradleModel androidModel = androidFacet.getNativeAndroidGradleModel();
        if (androidModel == null) {
            return null;
        }
        return androidModel;
    }

    public NativeAndroidGradleModel(@NotNull ProjectSystemId projectSystemId, @NotNull String moduleName, @NotNull File rootDirPath, @NotNull NativeAndroidProject nativeAndroidProject) {
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/android/tools/idea/gradle/NativeAndroidGradleModel", "<init>"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/NativeAndroidGradleModel", "<init>"));
        }
        if (rootDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDirPath", "com/android/tools/idea/gradle/NativeAndroidGradleModel", "<init>"));
        }
        if (nativeAndroidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeAndroidProject", "com/android/tools/idea/gradle/NativeAndroidGradleModel", "<init>"));
        }
        this.myVariantsByName = Maps.newHashMap();
        this.myToolchainsByName = Maps.newHashMap();
        this.mySettingsByName = Maps.newHashMap();
        this.myProjectSystemId = projectSystemId;
        this.myModuleName = moduleName;
        this.myRootDirPath = rootDirPath;
        this.myNativeAndroidProject = nativeAndroidProject;
        this.populateVariantsByName();
        this.populateToolchainsByName();
        this.populateSettingsByName();
        this.initializeSelectedVariant();
    }

    private void populateVariantsByName() {
        for (NativeArtifact artifact : this.myNativeAndroidProject.getArtifacts()) {
            String variantName = artifact.getGroupName();
            NativeVariant variant = this.myVariantsByName.get(variantName);
            if (variant == null) {
                variant = new NativeVariant(variantName);
                this.myVariantsByName.put(variant.getName(), variant);
            }
            variant.addArtifact(artifact);
        }
        if (this.myVariantsByName.isEmpty()) {
            this.myVariantsByName.put("-----", new NativeVariant("-----"));
        }
    }

    private void populateToolchainsByName() {
        for (NativeToolchain toolchain : this.myNativeAndroidProject.getToolChains()) {
            this.myToolchainsByName.put(toolchain.getName(), toolchain);
        }
    }

    private void populateSettingsByName() {
        for (NativeSettings settings : this.myNativeAndroidProject.getSettings()) {
            this.mySettingsByName.put(settings.getName(), settings);
        }
    }

    private void initializeSelectedVariant() {
        Set<String> variantNames = this.myVariantsByName.keySet();
        assert (!variantNames.isEmpty());
        if (variantNames.size() == 1) {
            this.mySelectedVariantName = (String)Iterables.getOnlyElement(variantNames);
            return;
        }
        for (String variantName : variantNames) {
            if (!variantName.equals("debug")) continue;
            this.mySelectedVariantName = variantName;
            return;
        }
        ArrayList sortedVariantNames = Lists.newArrayList(variantNames);
        Collections.sort(sortedVariantNames);
        assert (!sortedVariantNames.isEmpty());
        this.mySelectedVariantName = (String)sortedVariantNames.get(0);
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        ProjectSystemId projectSystemId = this.myProjectSystemId;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/NativeAndroidGradleModel", "getProjectSystemId"));
        }
        return projectSystemId;
    }

    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/NativeAndroidGradleModel", "getModuleName"));
        }
        return string;
    }

    @NotNull
    public File getRootDirPath() {
        File file = this.myRootDirPath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/NativeAndroidGradleModel", "getRootDirPath"));
        }
        return file;
    }

    @NotNull
    public NativeAndroidProject getNativeAndroidProject() {
        NativeAndroidProject nativeAndroidProject = this.myNativeAndroidProject;
        if (nativeAndroidProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/NativeAndroidGradleModel", "getNativeAndroidProject"));
        }
        return nativeAndroidProject;
    }

    @NotNull
    public Collection<String> getVariantNames() {
        Set<String> set = this.myVariantsByName.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/NativeAndroidGradleModel", "getVariantNames"));
        }
        return set;
    }

    @NotNull
    public Collection<NativeVariant> getVariants() {
        Collection<NativeVariant> collection = this.myVariantsByName.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/NativeAndroidGradleModel", "getVariants"));
        }
        return collection;
    }

    @NotNull
    public NativeVariant getSelectedVariant() {
        NativeVariant selected = this.myVariantsByName.get(this.mySelectedVariantName);
        assert (selected != null);
        NativeVariant nativeVariant = selected;
        if (nativeVariant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/NativeAndroidGradleModel", "getSelectedVariant"));
        }
        return nativeVariant;
    }

    public void setSelectedVariantName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/NativeAndroidGradleModel", "setSelectedVariantName"));
        }
        Collection<String> variantNames = this.getVariantNames();
        if (variantNames.contains(name)) {
            this.mySelectedVariantName = name;
        } else {
            this.initializeSelectedVariant();
        }
    }

    @Nullable
    public NativeToolchain findToolchain(@NotNull String toolchainName) {
        if (toolchainName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolchainName", "com/android/tools/idea/gradle/NativeAndroidGradleModel", "findToolchain"));
        }
        return this.myToolchainsByName.get(toolchainName);
    }

    @Nullable
    public NativeSettings findSettings(@NotNull String settingsName) {
        if (settingsName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsName", "com/android/tools/idea/gradle/NativeAndroidGradleModel", "findSettings"));
        }
        return this.mySettingsByName.get(settingsName);
    }

    public static class NativeVariant {
        @NotNull
        private final String myVariantName;
        @NotNull
        private final Map<String, NativeArtifact> myArtifactsByName;

        private NativeVariant(@NotNull String variantName) {
            if (variantName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantName", "com/android/tools/idea/gradle/NativeAndroidGradleModel$NativeVariant", "<init>"));
            }
            this.myArtifactsByName = Maps.newHashMap();
            this.myVariantName = variantName;
        }

        private void addArtifact(@NotNull NativeArtifact artifact) {
            if (artifact == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/NativeAndroidGradleModel$NativeVariant", "addArtifact"));
            }
            this.myArtifactsByName.put(artifact.getName(), artifact);
        }

        @NotNull
        public String getName() {
            String string = this.myVariantName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/NativeAndroidGradleModel$NativeVariant", "getName"));
            }
            return string;
        }

        @NotNull
        public Collection<NativeArtifact> getArtifacts() {
            Collection<NativeArtifact> collection = this.myArtifactsByName.values();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/NativeAndroidGradleModel$NativeVariant", "getArtifacts"));
            }
            return collection;
        }

        @NotNull
        public Collection<File> getSourceFolders() {
            LinkedHashSet sourceFolders = Sets.newLinkedHashSet();
            for (NativeArtifact artifact : this.getArtifacts()) {
                for (File headerRoot : artifact.getExportedHeaders()) {
                    sourceFolders.add(headerRoot);
                }
                for (NativeFolder sourceFolder : artifact.getSourceFolders()) {
                    sourceFolders.add(sourceFolder.getFolderPath());
                }
                for (NativeFile sourceFile : artifact.getSourceFiles()) {
                    File parentFile = sourceFile.getFilePath().getParentFile();
                    if (parentFile == null) continue;
                    sourceFolders.add(parentFile);
                }
            }
            ImmutableList immutableList = ImmutableList.copyOf((Collection)sourceFolders);
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/NativeAndroidGradleModel$NativeVariant", "getSourceFolders"));
            }
            return immutableList;
        }
    }
}

