/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer;

import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.customizer.dependency.DependencySetupErrors;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDependenciesModuleCustomizer<T>
implements ModuleCustomizer<T> {
    @Override
    public void customizeModule(@NotNull Project project, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @Nullable T externalProjectModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "customizeModule"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "customizeModule"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "customizeModule"));
        }
        if (externalProjectModel == null) {
            return;
        }
        ModifiableRootModel moduleModel = modelsProvider.getModifiableRootModel(module);
        AbstractDependenciesModuleCustomizer.removeExistingDependencies(moduleModel);
        this.setUpDependencies(module, modelsProvider, externalProjectModel);
    }

    protected abstract void setUpDependencies(@NotNull Module var1, @NotNull IdeModifiableModelsProvider var2, @NotNull T var3);

    @NotNull
    protected DependencySetupErrors getSetupErrors(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "getSetupErrors"));
        }
        DependencySetupErrors setupErrors = Projects.getDependencySetupErrors(project);
        if (setupErrors == null) {
            setupErrors = new DependencySetupErrors();
            Projects.setDependencySetupErrors(project, setupErrors);
        }
        DependencySetupErrors dependencySetupErrors = setupErrors;
        if (dependencySetupErrors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "getSetupErrors"));
        }
        return dependencySetupErrors;
    }

    private static void removeExistingDependencies(@NotNull ModifiableRootModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "removeExistingDependencies"));
        }
        DependencyRemover dependencyRemover = new DependencyRemover(model);
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            orderEntry.accept((RootPolicy)dependencyRemover, null);
        }
    }

    protected static void setUpLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull String libraryName, @NotNull DependencyScope scope, @NotNull Collection<String> binaryPaths) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (binaryPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryPaths", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        List<String> empty = Collections.emptyList();
        AbstractDependenciesModuleCustomizer.setUpLibraryDependency(module, modelsProvider, libraryName, scope, binaryPaths, empty, empty);
    }

    protected static void setUpLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull String libraryName, @NotNull DependencyScope scope, @NotNull Collection<String> binaryPaths, @NotNull Collection<String> sourcePaths, @NotNull Collection<String> documentationPaths) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (binaryPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryPaths", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (sourcePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePaths", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (documentationPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentationPaths", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        Library library = modelsProvider.getLibraryByName(libraryName);
        if (library == null) {
            library = modelsProvider.createLibrary(libraryName);
            AbstractDependenciesModuleCustomizer.updateLibraryBinaryPaths(library, binaryPaths, modelsProvider);
        }
        AbstractDependenciesModuleCustomizer.updateLibrarySourcesIfAbsent(library, sourcePaths, OrderRootType.SOURCES, modelsProvider);
        AbstractDependenciesModuleCustomizer.updateLibrarySourcesIfAbsent(library, documentationPaths, JavadocOrderRootType.getInstance(), modelsProvider);
        for (String binaryPath : binaryPaths) {
            File annotations;
            if (!binaryPath.endsWith("res") || binaryPath.length() <= "res".length() || binaryPath.charAt(binaryPath.length() - "res".length() - 1) != File.separatorChar || !(annotations = new File(binaryPath.substring(0, binaryPath.length() - "res".length()), "annotations.zip")).isFile()) continue;
            AbstractDependenciesModuleCustomizer.updateLibrarySourcesIfAbsent(library, Collections.singletonList(annotations.getPath()), AnnotationOrderRootType.getInstance(), modelsProvider);
        }
        LibraryOrderEntry orderEntry = modelsProvider.getModifiableRootModel(module).addLibraryEntry(library);
        orderEntry.setScope(scope);
        orderEntry.setExported(true);
    }

    private static void updateLibraryBinaryPaths(@NotNull Library library, @NotNull Collection<String> binaryPaths, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "updateLibraryBinaryPaths"));
        }
        if (binaryPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryPaths", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "updateLibraryBinaryPaths"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "updateLibraryBinaryPaths"));
        }
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
        for (String path : binaryPaths) {
            String url = AbstractDependenciesModuleCustomizer.pathToUrl(path);
            libraryModel.addRoot(url, OrderRootType.CLASSES);
        }
    }

    private static void updateLibrarySourcesIfAbsent(@NotNull Library library, @NotNull Collection<String> paths, @NotNull OrderRootType pathType, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "updateLibrarySourcesIfAbsent"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "updateLibrarySourcesIfAbsent"));
        }
        if (pathType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathType", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "updateLibrarySourcesIfAbsent"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "updateLibrarySourcesIfAbsent"));
        }
        if (paths.isEmpty() || library.getFiles(pathType).length > 0) {
            return;
        }
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
        for (String path : paths) {
            libraryModel.addRoot(AbstractDependenciesModuleCustomizer.pathToUrl(path), pathType);
        }
    }

    @NotNull
    public static String pathToUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "pathToUrl"));
        }
        File file = new File(path);
        String name = file.getName();
        boolean isJarFile = FileUtilRt.extensionEquals((String)name, (String)"jar") || FileUtilRt.extensionEquals((String)name, (String)"zip");
        String protocol = isJarFile ? "jar" : "file";
        String url = VirtualFileManager.constructUrl((String)protocol, (String)FileUtil.toSystemIndependentName((String)file.getPath()));
        if (isJarFile) {
            url = url + "!/";
        }
        String string = url;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "pathToUrl"));
        }
        return string;
    }

    private static class DependencyRemover
    extends RootPolicy<Object> {
        @NotNull
        private final ModifiableRootModel myModel;

        DependencyRemover(@NotNull ModifiableRootModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer$DependencyRemover", "<init>"));
            }
            this.myModel = model;
        }

        public Object visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, Object value) {
            this.myModel.removeOrderEntry((OrderEntry)libraryOrderEntry);
            return value;
        }

        public Object visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, Object value) {
            this.myModel.removeOrderEntry((OrderEntry)moduleOrderEntry);
            return value;
        }
    }
}

