/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.java;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.JavaProject;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.util.Facets;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.pom.java.LanguageLevel;
import java.util.ArrayList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLanguageLevelModuleCustomizer
implements ModuleCustomizer<JavaProject> {
    @Override
    public void customizeModule(@NotNull Project project, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @Nullable JavaProject javaProject) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/customizer/java/JavaLanguageLevelModuleCustomizer", "customizeModule"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/java/JavaLanguageLevelModuleCustomizer", "customizeModule"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/java/JavaLanguageLevelModuleCustomizer", "customizeModule"));
        }
        if (javaProject == null) {
            return;
        }
        LanguageLevel languageLevel = javaProject.getJavaLanguageLevel();
        if (languageLevel == null) {
            languageLevel = JavaLanguageLevelModuleCustomizer.getMinimumLanguageLevelForAndroidModules(modelsProvider);
        }
        if (languageLevel == null) {
            languageLevel = LanguageLevel.JDK_1_6;
        }
        ModifiableRootModel rootModel = modelsProvider.getModifiableRootModel(module);
        LanguageLevelModuleExtensionImpl moduleExtension = (LanguageLevelModuleExtensionImpl)rootModel.getModuleExtension(LanguageLevelModuleExtensionImpl.class);
        moduleExtension.setLanguageLevel(languageLevel);
    }

    @Nullable
    private static LanguageLevel getMinimumLanguageLevelForAndroidModules(@NotNull IdeModifiableModelsProvider modelsProvider) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/java/JavaLanguageLevelModuleCustomizer", "getMinimumLanguageLevelForAndroidModules"));
        }
        Module[] modules = modelsProvider.getModules();
        if (modules.length == 0) {
            return null;
        }
        LanguageLevel result = null;
        ArrayList languageLevels = Lists.newArrayList();
        for (Module dependency : modules) {
            LanguageLevel dependencyLanguageLevel = JavaLanguageLevelModuleCustomizer.getLanguageLevelForAndroidModule(dependency, modelsProvider);
            if (dependencyLanguageLevel == null) continue;
            languageLevels.add(dependencyLanguageLevel);
        }
        for (LanguageLevel dependencyLanguageLevel : languageLevels) {
            if (result != null && result.compareTo((Enum)dependencyLanguageLevel) <= 0) continue;
            result = dependencyLanguageLevel;
        }
        return result;
    }

    @Nullable
    private static LanguageLevel getLanguageLevelForAndroidModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        AndroidGradleModel androidModel;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/java/JavaLanguageLevelModuleCustomizer", "getLanguageLevelForAndroidModule"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/java/JavaLanguageLevelModuleCustomizer", "getLanguageLevelForAndroidModule"));
        }
        AndroidFacet facet = Facets.findFacet(module, modelsProvider, AndroidFacet.ID);
        if (facet != null && (androidModel = AndroidGradleModel.get(facet)) != null) {
            return androidModel.getJavaLanguageLevel();
        }
        return null;
    }
}

