/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.compatibility;

import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.project.compatibility.BuildFileComponentVersionReader;
import com.android.tools.idea.gradle.project.compatibility.ComponentVersionReader;
import com.android.tools.idea.gradle.project.compatibility.FileLocation;
import com.android.tools.idea.gradle.project.compatibility.VersionRange;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.intellij.lang.annotations.Language;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionCompatibilityService {
    private static Logger LOG = Logger.getInstance(VersionCompatibilityService.class);
    @NonNls
    private static final String BUILD_FILE_PREFIX = "buildFile:";
    @NonNls
    private static final String METADATA_FILE_NAME = "android-component-compatibility.xml";
    @NotNull
    private VersionMetadata myMetadata = new VersionMetadata(1);

    @NotNull
    public static VersionCompatibilityService getInstance() {
        VersionCompatibilityService versionCompatibilityService = (VersionCompatibilityService)ServiceManager.getService(VersionCompatibilityService.class);
        if (versionCompatibilityService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService", "getInstance"));
        }
        return versionCompatibilityService;
    }

    public VersionCompatibilityService() {
        this.reloadMetadata();
    }

    @VisibleForTesting
    public void reloadMetadata() {
        File metadataFilePath = VersionCompatibilityService.getMetadataFilePath();
        if (metadataFilePath.isFile()) {
            try {
                Element root = JDOMUtil.load((File)metadataFilePath);
                this.myMetadata = VersionCompatibilityService.loadMetadata(root);
            }
            catch (Throwable e) {
                LOG.info("Failed to load/parse file '" + metadataFilePath.getPath() + "'. Loading metadata from local file.", e);
                this.loadLocalMetadata();
            }
        } else {
            this.loadLocalMetadata();
        }
    }

    @VisibleForTesting
    public void reloadMetadataForTesting(@NotNull @Language(value="XML") String metadata) throws JDOMException, IOException {
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService", "reloadMetadataForTesting"));
        }
        this.myMetadata = VersionCompatibilityService.loadMetadata(JdomKt.loadElement((CharSequence)metadata));
    }

    boolean updateMetadata(@NotNull Document metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService", "updateMetadata"));
        }
        try {
            VersionMetadata updated = VersionCompatibilityService.loadMetadata(metadata.getRootElement());
            if (updated.dataVersion > this.myMetadata.dataVersion) {
                this.myMetadata = updated;
                File metadataFilePath = VersionCompatibilityService.getMetadataFilePath();
                JDOMUtil.writeDocument((Document)metadata, (File)metadataFilePath, (String)SystemProperties.getLineSeparator());
                LOG.info("Saved component version metadata to: " + metadataFilePath);
                return true;
            }
        }
        catch (Throwable e) {
            LOG.info("Failed to update component version metadata", e);
        }
        return false;
    }

    @VisibleForTesting
    @NotNull
    public static File getMetadataFilePath() {
        File configPath = new File(FileUtil.toSystemDependentName((String)PathManager.getConfigPath()));
        File file = new File(configPath, METADATA_FILE_NAME);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService", "getMetadataFilePath"));
        }
        return file;
    }

    private void loadLocalMetadata() {
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream(METADATA_FILE_NAME);
            this.myMetadata = VersionCompatibilityService.loadMetadata(JdomKt.loadElement((InputStream)inputStream));
        }
        catch (Throwable e) {
            LOG.info("Failed to load/parse local metadata file.", e);
        }
        finally {
            try {
                Closeables.close((Closeable)inputStream, (boolean)true);
            }
            catch (IOException iOException) {}
        }
    }

    @NotNull
    private static VersionMetadata loadMetadata(@NotNull Element root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService", "loadMetadata"));
        }
        String dataVersionText = root.getAttributeValue("version");
        int dataVersion = 1;
        try {
            dataVersion = Integer.parseInt(dataVersionText);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        VersionMetadata metadata = new VersionMetadata(dataVersion);
        for (Element checkElement : root.getChildren("check")) {
            Element componentElement = checkElement.getChild("component");
            ComponentVersion version = VersionCompatibilityService.createComponentVersion(componentElement, metadata);
            for (Element requirementElement : componentElement.getChildren("requires")) {
                version.requirements.add(VersionCompatibilityService.createComponentVersion(requirementElement, metadata));
            }
            String type = checkElement.getAttributeValue("failureType");
            CompatibilityCheck check = new CompatibilityCheck(version, VersionCompatibilityService.getFailureType(type));
            metadata.compatibilityChecks.add(check);
        }
        VersionMetadata versionMetadata = metadata;
        if (versionMetadata == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService", "loadMetadata"));
        }
        return versionMetadata;
    }

    @NotNull
    private static Message.Type getFailureType(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService", "getFailureType"));
        }
        Message.Type type = Message.Type.find(value);
        Message.Type type2 = type != null ? type : Message.Type.ERROR;
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService", "getFailureType"));
        }
        return type2;
    }

    @NotNull
    private static ComponentVersion createComponentVersion(@NotNull Element xmlElement, @NotNull VersionMetadata metadata) {
        if (xmlElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlElement", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService", "createComponentVersion"));
        }
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService", "createComponentVersion"));
        }
        String name = xmlElement.getAttribute("name").getValue();
        if (name.startsWith(BUILD_FILE_PREFIX)) {
            name = name.substring(BUILD_FILE_PREFIX.length());
            ComponentVersionReader reader = (ComponentVersionReader)metadata.versionReadersByComponentName.get(name);
            if (reader == null) {
                metadata.versionReadersByComponentName.put(name, new BuildFileComponentVersionReader(name));
            }
        }
        String version = xmlElement.getAttributeValue("version");
        String failureMsg = null;
        Element failureMsgElement = xmlElement.getChild("failureMsg");
        if (failureMsgElement != null) {
            failureMsg = Strings.emptyToNull((String)failureMsgElement.getTextNormalize());
        }
        ComponentVersion componentVersion = new ComponentVersion(name, version, failureMsg);
        if (componentVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService", "createComponentVersion"));
        }
        return componentVersion;
    }

    @NotNull
    public List<VersionIncompatibilityMessage> checkComponentCompatibility(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService", "checkComponentCompatibility"));
        }
        CompatibilityChecker checker = new CompatibilityChecker(project, this.myMetadata);
        List<VersionIncompatibilityMessage> list = checker.execute();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService", "checkComponentCompatibility"));
        }
        return list;
    }

    public static class VersionIncompatibilityMessage {
        @NotNull
        private final Message myMessage;
        @NotNull
        private final NotificationHyperlink[] myQuickFixes;

        VersionIncompatibilityMessage(@NotNull Message message, @NotNull List<NotificationHyperlink> quickFixes) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$VersionIncompatibilityMessage", "<init>"));
            }
            if (quickFixes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixes", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$VersionIncompatibilityMessage", "<init>"));
            }
            this.myMessage = message;
            this.myQuickFixes = quickFixes.toArray(new NotificationHyperlink[quickFixes.size()]);
        }

        @NotNull
        public Message getMessage() {
            Message message = this.myMessage;
            if (message == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$VersionIncompatibilityMessage", "getMessage"));
            }
            return message;
        }

        @NotNull
        public NotificationHyperlink[] getQuickFixes() {
            if (this.myQuickFixes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$VersionIncompatibilityMessage", "getQuickFixes"));
            }
            return this.myQuickFixes;
        }
    }

    private static class ComponentVersion {
        @NotNull
        final String componentName;
        @NotNull
        final VersionRange versionRange;
        @Nullable
        final String failureMsg;
        @NotNull
        final List<ComponentVersion> requirements;

        ComponentVersion(@NotNull String componentName, @NotNull String version, @Nullable String failureMsg) {
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$ComponentVersion", "<init>"));
            }
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$ComponentVersion", "<init>"));
            }
            this.requirements = Lists.newArrayList();
            this.componentName = componentName;
            this.versionRange = VersionRange.parse(version);
            this.failureMsg = failureMsg;
        }

        private static class Incompatibility {
            @NotNull
            final Module module;
            @NotNull
            final CompatibilityCheck compatibilityCheck;
            @NotNull
            final Pair<ComponentVersionReader, String> readerAndVersion;
            @NotNull
            final ComponentVersion requirement;
            @NotNull
            final ComponentVersionReader requirementVersionReader;
            @NotNull
            final List<String> messages;

            Incompatibility(@NotNull Module module, @NotNull CompatibilityCheck compatibilityCheck, @NotNull Pair<ComponentVersionReader, String> readerAndVersion, @NotNull ComponentVersion requirement, @NotNull ComponentVersionReader requirementVersionReader) {
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$ComponentVersion$Incompatibility", "<init>"));
                }
                if (compatibilityCheck == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compatibilityCheck", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$ComponentVersion$Incompatibility", "<init>"));
                }
                if (readerAndVersion == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readerAndVersion", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$ComponentVersion$Incompatibility", "<init>"));
                }
                if (requirement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirement", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$ComponentVersion$Incompatibility", "<init>"));
                }
                if (requirementVersionReader == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirementVersionReader", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$ComponentVersion$Incompatibility", "<init>"));
                }
                this.messages = Lists.newArrayList();
                this.module = module;
                this.compatibilityCheck = compatibilityCheck;
                this.readerAndVersion = readerAndVersion;
                this.requirement = requirement;
                this.requirementVersionReader = requirementVersionReader;
            }
        }
    }

    private static class CompatibilityCheck {
        @NotNull
        final ComponentVersion myComponentVersion;
        @NotNull
        final Message.Type failureType;

        CompatibilityCheck(@NotNull ComponentVersion componentVersion, @NotNull Message.Type failureType) {
            if (componentVersion == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentVersion", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$CompatibilityCheck", "<init>"));
            }
            if (failureType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failureType", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$CompatibilityCheck", "<init>"));
            }
            this.myComponentVersion = componentVersion;
            this.failureType = failureType;
        }
    }

    private static class VersionMetadata {
        final int dataVersion;
        @NotNull
        private final List<CompatibilityCheck> compatibilityChecks = Lists.newArrayList();
        @NotNull
        private final Map<String, ComponentVersionReader> versionReadersByComponentName = Maps.newConcurrentMap();

        VersionMetadata(int dataVersion) {
            this.dataVersion = dataVersion;
            this.versionReadersByComponentName.put("gradle", ComponentVersionReader.GRADLE);
            this.versionReadersByComponentName.put("android-gradle-plugin", ComponentVersionReader.ANDROID_GRADLE_PLUGIN);
            if (AndroidStudioInitializer.isAndroidStudio()) {
                this.versionReadersByComponentName.put("android-studio", ComponentVersionReader.IDE);
            } else if (PlatformUtils.isIntelliJ()) {
                this.versionReadersByComponentName.put("idea", ComponentVersionReader.IDE);
            }
        }
    }

    private static class CompatibilityChecker {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VersionMetadata myMetadata;
        @NotNull
        private final Map<String, Pair<ComponentVersionReader, String>> myProjectComponentVersionCache;
        @NotNull
        private final Map<String, Map<String, Pair<ComponentVersionReader, String>>> myModuleComponentVersionCache;

        CompatibilityChecker(@NotNull Project project, @NotNull VersionMetadata metadata) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$CompatibilityChecker", "<init>"));
            }
            if (metadata == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$CompatibilityChecker", "<init>"));
            }
            this.myProjectComponentVersionCache = Maps.newHashMap();
            this.myModuleComponentVersionCache = Maps.newHashMap();
            this.myProject = project;
            this.myMetadata = metadata;
        }

        @NotNull
        List<VersionIncompatibilityMessage> execute() {
            Module[] modules;
            HashMap incompatibilitiesByCheck = Maps.newHashMap();
            for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
                for (CompatibilityCheck check : this.myMetadata.compatibilityChecks) {
                    String version;
                    ComponentVersion componentVersion = check.myComponentVersion;
                    Pair<ComponentVersionReader, String> readerAndVersion = this.getComponentVersion(componentVersion, module);
                    if (readerAndVersion == null || !componentVersion.versionRange.contains(version = (String)readerAndVersion.getSecond())) continue;
                    for (ComponentVersion requirement : componentVersion.requirements) {
                        Object msg;
                        String requirementVersion;
                        Pair<ComponentVersionReader, String> readerAndRequirementVersion = this.getComponentVersion(requirement, module);
                        if (readerAndRequirementVersion == null || requirement.versionRange.contains(requirementVersion = (String)readerAndRequirementVersion.getSecond())) continue;
                        boolean projectLevelCheck = ((ComponentVersionReader)readerAndVersion.getFirst()).isProjectLevel();
                        String id = projectLevelCheck ? check.myComponentVersion.componentName : module.getName() + "." + check.myComponentVersion.componentName;
                        ComponentVersion.Incompatibility incompatibility = (ComponentVersion.Incompatibility)incompatibilitiesByCheck.get(id);
                        if (incompatibility == null) {
                            ComponentVersionReader requirementVersionReader = (ComponentVersionReader)readerAndRequirementVersion.getFirst();
                            incompatibility = new ComponentVersion.Incompatibility(module, check, readerAndVersion, requirement, requirementVersionReader);
                            incompatibilitiesByCheck.put(id, incompatibility);
                        }
                        if (((ComponentVersionReader)readerAndRequirementVersion.getFirst()).isProjectLevel()) {
                            if (!incompatibility.messages.isEmpty()) continue;
                            msg = String.format(" but project is using version %1$s.", requirementVersion);
                            incompatibility.messages.add((String)msg);
                            continue;
                        }
                        msg = String.format("Module '%1$s' is using version %2$s", module.getName(), requirementVersion);
                        incompatibility.messages.add((String)msg);
                    }
                }
            }
            if (incompatibilitiesByCheck.isEmpty()) {
                List<VersionIncompatibilityMessage> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$CompatibilityChecker", "execute"));
                }
                return list;
            }
            ArrayList failureMessages = Lists.newArrayList();
            for (ComponentVersion.Incompatibility incompatibility : incompatibilitiesByCheck.values()) {
                CompatibilityCheck check = incompatibility.compatibilityCheck;
                Pair<ComponentVersionReader, String> readerAndVersion = incompatibility.readerAndVersion;
                ComponentVersionReader reader = (ComponentVersionReader)readerAndVersion.getFirst();
                String componentName = reader.getComponentName();
                String version = (String)readerAndVersion.getSecond();
                ComponentVersionReader requirementVersionReader = incompatibility.requirementVersionReader;
                String requirementComponentName = requirementVersionReader.getComponentName();
                StringBuilder msg = new StringBuilder();
                msg.append(componentName).append(" ").append(version);
                Module module = incompatibility.module;
                FileLocation location = reader.getVersionSource(module);
                if (!reader.isProjectLevel() && location == null) {
                    msg.append(", in module '").append(module.getName()).append(",'");
                }
                msg.append(" requires ").append(requirementComponentName).append(" ");
                ComponentVersion requirement = incompatibility.requirement;
                VersionRange requirementVersionRange = requirement.versionRange;
                msg.append(requirementVersionRange.getDescription());
                List<String> messages = incompatibility.messages;
                if (messages.size() == 1) {
                    msg.append(" ").append(messages.get(0));
                } else {
                    msg.append("<ul>");
                    for (String message : messages) {
                        msg.append("<li>").append(message).append("</li>");
                    }
                    msg.append("</ul>");
                }
                String group = "Gradle Sync Issue";
                Message.Type failureType = check.failureType;
                ArrayList textLines = Lists.newArrayList();
                textLines.add(msg.toString());
                String failureMsg = requirement.failureMsg;
                if (failureMsg != null) {
                    List lines = Splitter.on((String)"\\n").omitEmptyStrings().splitToList((CharSequence)failureMsg);
                    textLines.addAll(lines);
                }
                String[] text = ArrayUtil.toStringArray((Collection)textLines);
                Message message = location != null ? new Message(this.myProject, group, failureType, location.file, location.lineNumber, location.column, text) : new Message(group, failureType, text);
                ArrayList quickFixes = Lists.newArrayList();
                quickFixes.addAll(reader.getQuickFixes(module, null, null));
                quickFixes.addAll(requirementVersionReader.getQuickFixes(module, requirementVersionRange, location));
                failureMessages.add(new VersionIncompatibilityMessage(message, quickFixes));
            }
            ArrayList arrayList = failureMessages;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$CompatibilityChecker", "execute"));
            }
            return arrayList;
        }

        @Nullable
        private Pair<ComponentVersionReader, String> getComponentVersion(@NotNull ComponentVersion componentVersion, @NotNull Module module) {
            Map<String, Pair<ComponentVersionReader, String>> componentVersionsByModule;
            if (componentVersion == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentVersion", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$CompatibilityChecker", "getComponentVersion"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/compatibility/VersionCompatibilityService$CompatibilityChecker", "getComponentVersion"));
            }
            String componentName = componentVersion.componentName;
            Pair readerAndVersion = this.myProjectComponentVersionCache.get(componentName);
            if (readerAndVersion == null && (componentVersionsByModule = this.myModuleComponentVersionCache.get(componentName)) != null) {
                readerAndVersion = componentVersionsByModule.get(module.getName());
            }
            if (readerAndVersion == null) {
                ComponentVersionReader reader = (ComponentVersionReader)this.myMetadata.versionReadersByComponentName.get(componentName);
                if (reader == null) {
                    LOG.info(String.format("Failed to find version reader for component '%1$s'", componentName));
                    return null;
                }
                if (!reader.appliesTo(module)) {
                    return null;
                }
                String version = reader.getComponentVersion(module);
                if (version != null) {
                    readerAndVersion = Pair.create((Object)reader, (Object)version);
                    if (reader.isProjectLevel()) {
                        this.myProjectComponentVersionCache.put(componentName, (Pair<ComponentVersionReader, String>)readerAndVersion);
                    } else {
                        HashMap componentVersionsByModule2 = this.myModuleComponentVersionCache.get(componentName);
                        if (componentVersionsByModule2 == null) {
                            componentVersionsByModule2 = Maps.newHashMap();
                            this.myModuleComponentVersionCache.put(componentName, componentVersionsByModule2);
                        }
                        componentVersionsByModule2.put(module.getName(), readerAndVersion);
                    }
                } else {
                    Project project = module.getProject();
                    String msg = String.format("Failed to read version for component '%1$s'", componentName);
                    msg = reader.isProjectLevel() ? msg + String.format(" for project '%1$s'", project.getName()) : msg + String.format(" for module '%1$s', in project '%2$s'", module.getName(), project.getName());
                    LOG.info(msg);
                }
            }
            return readerAndVersion;
        }
    }
}

