/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.quickfix;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.quickfix.AbstractGradleAwareFix;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleIncreaseLanguageLevelFix
extends AbstractGradleAwareFix {
    private static final Logger LOG = Logger.getInstance(GradleIncreaseLanguageLevelFix.class);
    @NotNull
    private final LanguageLevel myLevel;
    @NotNull
    private final GradleBuildFile myBuildFile;

    public GradleIncreaseLanguageLevelFix(@NotNull LanguageLevel targetLevel, @NotNull GradleBuildFile buildFile) {
        if (targetLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetLevel", "com/android/tools/idea/gradle/quickfix/GradleIncreaseLanguageLevelFix", "<init>"));
        }
        if (buildFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildFile", "com/android/tools/idea/gradle/quickfix/GradleIncreaseLanguageLevelFix", "<init>"));
        }
        this.myLevel = targetLevel;
        this.myBuildFile = buildFile;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"set.language.level.to.0", (Object[])new Object[]{this.myLevel.getPresentableText()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/GradleIncreaseLanguageLevelFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"set.language.level", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/GradleIncreaseLanguageLevelFix", "getFamilyName"));
        }
        return string;
    }

    private static boolean isJdkSupportsLevel(@Nullable Sdk jdk, @NotNull LanguageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/android/tools/idea/gradle/quickfix/GradleIncreaseLanguageLevelFix", "isJdkSupportsLevel"));
        }
        if (jdk == null) {
            return true;
        }
        String versionString = jdk.getVersionString();
        JavaSdkVersion version = versionString == null ? null : JdkVersionUtil.getVersion((String)versionString);
        return version != null && version.getMaxLanguageLevel().isAtLeast(level);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/GradleIncreaseLanguageLevelFix", "isAvailable"));
        }
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        return module != null && GradleIncreaseLanguageLevelFix.isLanguageLevelAcceptable(project, module, this.myLevel);
    }

    private static boolean isLanguageLevelAcceptable(@NotNull Project project, @NotNull Module module, @NotNull LanguageLevel level) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/GradleIncreaseLanguageLevelFix", "isLanguageLevelAcceptable"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/quickfix/GradleIncreaseLanguageLevelFix", "isLanguageLevelAcceptable"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/android/tools/idea/gradle/quickfix/GradleIncreaseLanguageLevelFix", "isLanguageLevelAcceptable"));
        }
        return GradleIncreaseLanguageLevelFix.isJdkSupportsLevel(GradleIncreaseLanguageLevelFix.getRelevantJdk(project, module), level);
    }

    public void invoke(final @NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/GradleIncreaseLanguageLevelFix", "invoke"));
        }
        if (file == null) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        final Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        final LanguageLevel moduleLevel = module == null ? null : LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel();
        GradleIncreaseLanguageLevelFix.runWriteCommandActionAndSync(project, new Runnable(){

            @Override
            public void run() {
                if (moduleLevel != null && GradleIncreaseLanguageLevelFix.isLanguageLevelAcceptable(project, module, GradleIncreaseLanguageLevelFix.this.myLevel)) {
                    String gradleJavaVersion = GradleIncreaseLanguageLevelFix.getGradleJavaVersionString(GradleIncreaseLanguageLevelFix.this.myLevel);
                    if (GradleUtil.getAndroidProject(module) != null) {
                        GradleIncreaseLanguageLevelFix.this.myBuildFile.setValue(BuildFileKey.SOURCE_COMPATIBILITY, gradleJavaVersion);
                        GradleIncreaseLanguageLevelFix.this.myBuildFile.setValue(BuildFileKey.TARGET_COMPATIBILITY, gradleJavaVersion);
                    } else {
                        LOG.error("Setting language level on Java module is not supported");
                    }
                    AbstractGradleAwareFix.registerUndoAction(project);
                } else {
                    LOG.error("Tried to set language level without specify a module");
                }
            }
        }, null);
    }

    @Nullable
    private static Sdk getRelevantJdk(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/GradleIncreaseLanguageLevelFix", "getRelevantJdk"));
        }
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        Sdk moduleJdk = module == null ? null : ModuleRootManager.getInstance((Module)module).getSdk();
        return moduleJdk == null ? projectJdk : moduleJdk;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    private static String getGradleJavaVersionString(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/android/tools/idea/gradle/quickfix/GradleIncreaseLanguageLevelFix", "getGradleJavaVersionString"));
        }
        String string = "JavaVersion." + languageLevel.name().replaceAll("JDK", "VERSION");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/GradleIncreaseLanguageLevelFix", "getGradleJavaVersionString"));
        }
        return string;
    }
}

