/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public abstract class NotificationHyperlink {
    protected static final String ERROR_MSG_TITLE = "Quick Fix Failed";
    @NotNull
    private final String myUrl;
    @NotNull
    private final String myValue;
    @NotNull
    private boolean myCloseOnClick;

    protected NotificationHyperlink(@NotNull String url, @NotNull String text) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/gradle/service/notification/hyperlink/NotificationHyperlink", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/service/notification/hyperlink/NotificationHyperlink", "<init>"));
        }
        this.myUrl = url;
        this.myValue = String.format("<a href=\"%1$s\">%2$s</a>", StringUtil.escapeXml((String)url), text);
    }

    protected abstract void execute(@NotNull Project var1);

    public boolean executeIfClicked(@NotNull Project project, @NotNull HyperlinkEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/hyperlink/NotificationHyperlink", "executeIfClicked"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/gradle/service/notification/hyperlink/NotificationHyperlink", "executeIfClicked"));
        }
        if (this.myUrl.equals(event.getDescription())) {
            this.execute(project);
            return true;
        }
        return false;
    }

    public boolean isCloseOnClick() {
        return this.myCloseOnClick;
    }

    public NotificationHyperlink setCloseOnClick(boolean closeOnClick) {
        this.myCloseOnClick = closeOnClick;
        return this;
    }

    public String toString() {
        return this.toHtml();
    }

    @NotNull
    public String toHtml() {
        String string = this.myValue;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/notification/hyperlink/NotificationHyperlink", "toHtml"));
        }
        return string;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/notification/hyperlink/NotificationHyperlink", "getUrl"));
        }
        return string;
    }
}

