/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.editor.dependencies;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.ArtifactRepositorySearch;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.SearchResult;
import com.android.tools.idea.gradle.structure.configurables.model.ModuleMergedModel;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidSdkRepositorySearch
extends ArtifactRepositorySearch {
    private final List<GradleCoordinate> myGradleCoordinates;

    AndroidSdkRepositorySearch(@NotNull ModuleMergedModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/AndroidSdkRepositorySearch", "<init>"));
        }
        this(model, IdeSdks.getAndroidSdkPath());
    }

    @VisibleForTesting
    AndroidSdkRepositorySearch(@NotNull ModuleMergedModel model, @Nullable File androidSdkPath) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/AndroidSdkRepositorySearch", "<init>"));
        }
        this.myGradleCoordinates = Lists.newArrayList();
        if (androidSdkPath != null) {
            AndroidProject androidProject = model.getAndroidProject();
            boolean preview = AndroidSdkRepositorySearch.includePreview(androidProject);
            for (String libraryId : RepositoryUrlManager.EXTRAS_REPOSITORY.keySet()) {
                GradleCoordinate coordinate = AndroidSdkRepositorySearch.getLibraryCoordinate(libraryId, androidSdkPath, preview);
                if (coordinate == null) continue;
                this.myGradleCoordinates.add(coordinate);
            }
        }
    }

    @VisibleForTesting
    @Nullable
    static GradleCoordinate getLibraryCoordinate(@NotNull String libraryId, @NotNull File androidSdkPath, boolean preview) {
        if (libraryId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryId", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/AndroidSdkRepositorySearch", "getLibraryCoordinate"));
        }
        if (androidSdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdkPath", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/AndroidSdkRepositorySearch", "getLibraryCoordinate"));
        }
        RepositoryUrlManager.RepositoryLibrary library = RepositoryUrlManager.EXTRAS_REPOSITORY.get(libraryId);
        File metadataFile = new File(String.format(library.basePath, androidSdkPath, library.id), "maven-metadata.xml");
        String coordinateText = null;
        if (!metadataFile.exists()) {
            coordinateText = String.format(library.baseCoordinate, library.id, "0.0.+");
        } else {
            RepositoryUrlManager urlManager = RepositoryUrlManager.get();
            String version = urlManager.getLatestVersionFromMavenMetadata(metadataFile, null, preview);
            if (version != null) {
                coordinateText = String.format(library.baseCoordinate, library.id, version);
            }
        }
        return coordinateText != null ? GradleCoordinate.parseCoordinateString(coordinateText) : null;
    }

    private static boolean includePreview(@NotNull AndroidProject androidProject) {
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/AndroidSdkRepositorySearch", "includePreview"));
        }
        for (Variant variant : androidProject.getVariants()) {
            boolean preview;
            ApiVersion minSdkVersion = variant.getMergedFlavor().getMinSdkVersion();
            if (minSdkVersion == null || !(preview = new AndroidVersion(minSdkVersion.getApiLevel(), minSdkVersion.getCodename()).isPreview())) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    String getName() {
        if ("Android SDK" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/AndroidSdkRepositorySearch", "getName"));
        }
        return "Android SDK";
    }

    @Override
    boolean supportsPagination() {
        return false;
    }

    @Override
    @NotNull
    SearchResult start(@NotNull ArtifactRepositorySearch.Request request) throws IOException {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/AndroidSdkRepositorySearch", "start"));
        }
        ArrayList data = Lists.newArrayList();
        for (GradleCoordinate gradleCoordinate : this.myGradleCoordinates) {
            String groupId = request.groupId;
            if (StringUtil.isNotEmpty((String)groupId) && !groupId.equals(gradleCoordinate.getGroupId()) || !request.artifactName.equals(gradleCoordinate.getArtifactId())) continue;
            data.add(gradleCoordinate.toString());
        }
        SearchResult searchResult = new SearchResult(this.getName(), data, data.size());
        if (searchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/AndroidSdkRepositorySearch", "start"));
        }
        return searchResult;
    }
}

