/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.editors;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.structure.editors.GenericEditor;
import com.android.tools.idea.gradle.structure.editors.ModuleDependenciesPanel;
import com.android.tools.idea.gradle.structure.editors.NamedObjectPanel;
import com.android.tools.idea.gradle.structure.editors.SingleObjectPanel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleEditor
implements Place.Navigator,
Disposable {
    public static final ImmutableList<BuildFileKey> BUILD_FILE_GENERIC_PROPERTIES = ImmutableList.of((Object)((Object)BuildFileKey.COMPILE_SDK_VERSION), (Object)((Object)BuildFileKey.BUILD_TOOLS_VERSION), (Object)((Object)BuildFileKey.LIBRARY_REPOSITORY), (Object)((Object)BuildFileKey.IGNORE_ASSETS_PATTERN), (Object)((Object)BuildFileKey.INCREMENTAL_DEX), (Object)((Object)BuildFileKey.SOURCE_COMPATIBILITY), (Object)((Object)BuildFileKey.TARGET_COMPATIBILITY));
    private static final String SIGNING_TAB_TITLE = "Signing";
    private static final String BUILD_TYPES_TAB_TITLE = "Build Types";
    private static final String FLAVORS_TAB_TITLE = "Flavors";
    private final Project myProject;
    private final String myName;
    private final List<ModuleConfigurationEditor> myEditors;
    private JBTabbedPane myTabbedPane;
    private JComponent myGenericSettingsPanel;

    public AndroidModuleEditor(@NotNull Project project, @NotNull String moduleName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/editors/AndroidModuleEditor", "<init>"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/structure/editors/AndroidModuleEditor", "<init>"));
        }
        this.myEditors = new ArrayList<ModuleConfigurationEditor>();
        this.myProject = project;
        this.myName = moduleName;
    }

    @NotNull
    public JComponent getPanel() {
        Module module = GradleUtil.findModuleByGradlePath(this.myProject, this.myName);
        if (module == null || GradleUtil.getGradleBuildFile(module) == null) {
            JPanel jPanel = new JPanel();
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/editors/AndroidModuleEditor", "getPanel"));
            }
            return jPanel;
        }
        final NamedObjectPanel.PanelGroup panelGroup = new NamedObjectPanel.PanelGroup();
        if (this.myGenericSettingsPanel == null) {
            this.myEditors.clear();
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet != null && facet.requiresAndroidModel() && Projects.isBuildWithGradle(module)) {
                this.myEditors.add(new GenericEditor<SingleObjectPanel>("Properties", new Callable<SingleObjectPanel>(){

                    @Override
                    public SingleObjectPanel call() {
                        SingleObjectPanel panel = new SingleObjectPanel(AndroidModuleEditor.this.myProject, AndroidModuleEditor.this.myName, null, (List<BuildFileKey>)BUILD_FILE_GENERIC_PROPERTIES);
                        panel.init();
                        return panel;
                    }
                }));
                this.myEditors.add(new GenericEditor<NamedObjectPanel>(SIGNING_TAB_TITLE, new Callable<NamedObjectPanel>(){

                    @Override
                    public NamedObjectPanel call() {
                        NamedObjectPanel panel = new NamedObjectPanel(AndroidModuleEditor.this.myProject, AndroidModuleEditor.this.myName, BuildFileKey.SIGNING_CONFIGS, "config", panelGroup);
                        panel.init();
                        return panel;
                    }
                }));
                this.myEditors.add(new GenericEditor<NamedObjectPanel>(FLAVORS_TAB_TITLE, new Callable<NamedObjectPanel>(){

                    @Override
                    public NamedObjectPanel call() {
                        NamedObjectPanel panel = new NamedObjectPanel(AndroidModuleEditor.this.myProject, AndroidModuleEditor.this.myName, BuildFileKey.FLAVORS, "flavor", panelGroup);
                        panel.init();
                        return panel;
                    }
                }));
                this.myEditors.add(new GenericEditor<NamedObjectPanel>(BUILD_TYPES_TAB_TITLE, new Callable<NamedObjectPanel>(){

                    @Override
                    public NamedObjectPanel call() {
                        NamedObjectPanel panel = new NamedObjectPanel(AndroidModuleEditor.this.myProject, AndroidModuleEditor.this.myName, BuildFileKey.BUILD_TYPES, "buildType", panelGroup);
                        panel.init();
                        return panel;
                    }
                }));
            }
            this.myEditors.add(new GenericEditor<ModuleDependenciesPanel>(ProjectBundle.message((String)"modules.classpath.title", (Object[])new Object[0]), new Callable<ModuleDependenciesPanel>(){

                @Override
                public ModuleDependenciesPanel call() {
                    return new ModuleDependenciesPanel(AndroidModuleEditor.this.myProject, AndroidModuleEditor.this.myName);
                }
            }));
            this.myTabbedPane = new JBTabbedPane(1);
            for (ModuleConfigurationEditor editor : this.myEditors) {
                JComponent component = editor.createComponent();
                if (component == null) continue;
                this.myTabbedPane.addTab(editor.getDisplayName(), (Component)component);
                editor.reset();
            }
            this.myGenericSettingsPanel = this.myTabbedPane;
        }
        JComponent jComponent = this.myGenericSettingsPanel;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/editors/AndroidModuleEditor", "getPanel"));
        }
        return jComponent;
    }

    public void dispose() {
        for (ModuleConfigurationEditor myEditor : this.myEditors) {
            myEditor.disposeUIResources();
        }
        this.myEditors.clear();
        this.myGenericSettingsPanel = null;
    }

    public boolean isModified() {
        for (ModuleConfigurationEditor moduleElementsEditor : this.myEditors) {
            if (!moduleElementsEditor.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        for (ModuleConfigurationEditor editor : this.myEditors) {
            editor.saveData();
            editor.apply();
        }
    }

    public String getName() {
        return this.myName;
    }

    public void selectBuildTypesTab() {
        this.selectAndGetTabComponent(BUILD_TYPES_TAB_TITLE);
    }

    public void selectFlavorsTab() {
        this.selectAndGetTabComponent(FLAVORS_TAB_TITLE);
    }

    public void selectDependency(@NotNull GradleCoordinate dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/editors/AndroidModuleEditor", "selectDependency"));
        }
        Component selected = this.selectAndGetDependenciesTab();
        if (selected instanceof ModuleDependenciesPanel) {
            ModuleDependenciesPanel dependenciesPanel = (ModuleDependenciesPanel)selected;
            dependenciesPanel.select(dependency);
        }
    }

    public void selectDependenciesTab() {
        this.selectAndGetDependenciesTab();
    }

    @Nullable
    private Component selectAndGetDependenciesTab() {
        return this.selectAndGetTabComponent(ProjectBundle.message((String)"modules.classpath.title", (Object[])new Object[0]));
    }

    @Nullable
    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        return null;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/android/tools/idea/gradle/structure/editors/AndroidModuleEditor", "queryPlace"));
        }
    }

    public void setHistory(History history) {
    }

    public void openSigningConfiguration() {
        this.selectAndGetTabComponent(SIGNING_TAB_TITLE);
    }

    @Nullable
    private Component selectAndGetTabComponent(@NotNull String tabTitle) {
        if (tabTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabTitle", "com/android/tools/idea/gradle/structure/editors/AndroidModuleEditor", "selectAndGetTabComponent"));
        }
        int tabCount = this.myTabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            Component component = this.myTabbedPane.getTabComponentAt(i);
            if (!(component instanceof JLabel) || !tabTitle.equals(((JLabel)component).getText())) continue;
            this.myTabbedPane.setSelectedIndex(i);
            return this.myTabbedPane.getSelectedComponent();
        }
        return null;
    }
}

