/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.editors;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.structure.editors.KeyValuePane;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ActionRunner;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectConfigurable
extends NamedConfigurable
implements KeyValuePane.ModificationListener {
    private static final Logger LOG = Logger.getInstance(AndroidProjectConfigurable.class);
    private static final String DISPLAY_NAME = "Project";
    private final KeyValuePane myKeyValuePane;
    private final Project myProject;
    private final GradleBuildFile myGradleBuildFile;
    private final Map<BuildFileKey, Object> myProjectProperties = Maps.newHashMap();
    private Set<BuildFileKey> myModifiedKeys = Sets.newHashSet();
    public static final ImmutableList<BuildFileKey> PROJECT_PROPERTIES = ImmutableList.of((Object)((Object)BuildFileKey.GRADLE_WRAPPER_VERSION), (Object)((Object)BuildFileKey.PLUGIN_VERSION), (Object)((Object)BuildFileKey.PLUGIN_REPOSITORY), (Object)((Object)BuildFileKey.ALLPROJECTS_LIBRARY_REPOSITORY));

    public AndroidProjectConfigurable(Project project) {
        if (project.isDefault()) {
            throw new IllegalArgumentException("Can't instantiate an AndroidProjectConfigurable with the default project.");
        }
        this.myKeyValuePane = new KeyValuePane(project, this);
        this.myProject = project;
        VirtualFile vf = project.getBaseDir().findChild("build.gradle");
        this.myGradleBuildFile = vf != null ? new GradleBuildFile(vf, project) : null;
    }

    public void setDisplayName(String name) {
    }

    public Object getEditableObject() {
        return this.myProject;
    }

    public String getBannerSlogan() {
        return DISPLAY_NAME;
    }

    public JComponent createOptionsPanel() {
        this.myKeyValuePane.init(this.myGradleBuildFile, (Collection<BuildFileKey>)PROJECT_PROPERTIES);
        return this.myKeyValuePane;
    }

    @Nls
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    public boolean isModified() {
        return !this.myModifiedKeys.isEmpty();
    }

    @Override
    public void modified(@NotNull BuildFileKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/gradle/structure/editors/AndroidProjectConfigurable", "modified"));
        }
        this.myModifiedKeys.add(key);
    }

    public void apply() throws ConfigurationException {
        if (this.myGradleBuildFile == null) {
            return;
        }
        VirtualFile file = this.myGradleBuildFile.getFile();
        if (!ReadonlyStatusHandler.ensureFilesWritable((Project)this.myProject, (VirtualFile[])new VirtualFile[]{file})) {
            throw new ConfigurationException(String.format("Build file %1$s is not writable", file.getPath()));
        }
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

            @Override
            public void run() {
                try {
                    ActionRunner.runInsideWriteAction((ActionRunner.InterruptibleRunnable)new ActionRunner.InterruptibleRunnable(){

                        public void run() throws Exception {
                            VirtualFile virtualFile;
                            boolean updated;
                            for (BuildFileKey key : PROJECT_PROPERTIES) {
                                if (key == BuildFileKey.GRADLE_WRAPPER_VERSION || !AndroidProjectConfigurable.this.myModifiedKeys.contains((Object)key)) continue;
                                Object value = AndroidProjectConfigurable.this.myProjectProperties.get((Object)key);
                                if (value != null) {
                                    AndroidProjectConfigurable.this.myGradleBuildFile.setValue(key, value);
                                    continue;
                                }
                                AndroidProjectConfigurable.this.myGradleBuildFile.removeValue(null, key);
                            }
                            Object wrapperVersion = AndroidProjectConfigurable.this.myProjectProperties.get((Object)BuildFileKey.GRADLE_WRAPPER_VERSION);
                            File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(AndroidProjectConfigurable.this.myProject);
                            if (wrapperVersion != null && wrapperPropertiesFile != null && (updated = GradleUtil.updateGradleDistributionUrl(wrapperVersion.toString(), wrapperPropertiesFile)) && (virtualFile = VfsUtil.findFileByIoFile((File)wrapperPropertiesFile, (boolean)true)) != null) {
                                virtualFile.refresh(false, false);
                            }
                            AndroidProjectConfigurable.this.myModifiedKeys.clear();
                        }
                    });
                }
                catch (Exception e) {
                    LOG.error("Error while applying changes", (Throwable)e);
                }
            }
        });
    }

    public void reset() {
        this.myProjectProperties.clear();
        if (this.myGradleBuildFile == null) {
            return;
        }
        for (BuildFileKey key : PROJECT_PROPERTIES) {
            Object value = this.myGradleBuildFile.getValue(key);
            if (value == null) continue;
            this.myProjectProperties.put(key, value);
        }
        try {
            File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(this.myProject);
            if (wrapperPropertiesFile != null) {
                String wrapperVersion = GradleUtil.getGradleWrapperVersion(wrapperPropertiesFile);
                this.myProjectProperties.put(BuildFileKey.GRADLE_WRAPPER_VERSION, wrapperVersion);
            }
        }
        catch (Exception e) {
            LOG.warn("Error while saving Gradle wrapper properties", (Throwable)e);
        }
        this.myKeyValuePane.setCurrentBuildFileObject(this.myProjectProperties);
        this.myKeyValuePane.updateUiFromCurrentObject();
    }

    public void disposeUIResources() {
    }

    @Nullable
    public Icon getIcon(boolean expanded) {
        return AllIcons.Nodes.Project;
    }
}

