/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.google.common.base.Strings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProxySettings {
    @NonNls
    public static final String HTTP_PROXY_TYPE = "http";
    @NonNls
    public static final String HTTPS_PROXY_TYPE = "https";
    @NonNls
    private static final String PROXY_HOST_PROPERTY_SUFFIX = "proxyHost";
    @NonNls
    private static final String PROXY_PORT_PROPERTY_SUFFIX = "proxyPort";
    @NonNls
    private static final String PROXY_USER_PROPERTY_SUFFIX = "proxyUser";
    @NonNls
    private static final String PROXY_PASSWORD_PROPERTY_SUFFIX = "proxyPassword";
    @NonNls
    private static final String PROXY_EXCEPTIONS_PROPERTY_SUFFIX = "nonProxyHosts";
    @NotNull
    private String myProxyType;
    @Nullable
    private String myHost;
    @Nullable
    private String myExceptions;
    @Nullable
    private String myUser;
    @Nullable
    private String myPassword;
    private int myPort;

    public ProxySettings(@NotNull String proxyType) {
        if (proxyType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxyType", "com/android/tools/idea/gradle/util/ProxySettings", "<init>"));
        }
        this.myPort = 80;
        this.myProxyType = proxyType;
    }

    public ProxySettings(@NotNull Properties properties, @NotNull String proxyType) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/gradle/util/ProxySettings", "<init>"));
        }
        if (proxyType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxyType", "com/android/tools/idea/gradle/util/ProxySettings", "<init>"));
        }
        this.myPort = 80;
        this.myProxyType = proxyType;
        this.myHost = properties.getProperty(this.getProxyPropertyName(PROXY_HOST_PROPERTY_SUFFIX));
        String portValue = properties.getProperty(this.getProxyPropertyName(PROXY_PORT_PROPERTY_SUFFIX));
        if (StringUtil.isNotEmpty((String)portValue)) {
            try {
                this.myPort = Integer.parseInt(portValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.myExceptions = properties.getProperty(this.getProxyPropertyName(PROXY_EXCEPTIONS_PROPERTY_SUFFIX));
        this.myUser = properties.getProperty(this.getProxyPropertyName(PROXY_USER_PROPERTY_SUFFIX));
        this.myPassword = properties.getProperty(this.getProxyPropertyName(PROXY_PASSWORD_PROPERTY_SUFFIX));
    }

    public ProxySettings(@NotNull HttpConfigurable ideProxySettings) {
        if (ideProxySettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProxySettings", "com/android/tools/idea/gradle/util/ProxySettings", "<init>"));
        }
        this.myPort = 80;
        this.myProxyType = HTTP_PROXY_TYPE;
        this.myHost = ideProxySettings.PROXY_HOST;
        this.myPort = ideProxySettings.PROXY_PORT;
        if (ideProxySettings.PROXY_AUTHENTICATION) {
            this.myUser = ideProxySettings.getProxyLogin();
            this.myPassword = ideProxySettings.getPlainProxyPassword();
        }
        this.myExceptions = ideProxySettings.PROXY_EXCEPTIONS;
    }

    public void applyProxySettings(@NotNull Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/gradle/util/ProxySettings", "applyProxySettings"));
        }
        properties.setProperty(this.getProxyPropertyName(PROXY_HOST_PROPERTY_SUFFIX), this.myHost);
        properties.setProperty(this.getProxyPropertyName(PROXY_PORT_PROPERTY_SUFFIX), String.valueOf(this.myPort));
        if (StringUtil.isEmpty((String)this.myUser)) {
            properties.remove(this.getProxyPropertyName(PROXY_USER_PROPERTY_SUFFIX));
            properties.remove(this.getProxyPropertyName(PROXY_PASSWORD_PROPERTY_SUFFIX));
        } else {
            properties.setProperty(this.getProxyPropertyName(PROXY_USER_PROPERTY_SUFFIX), this.myUser);
            properties.setProperty(this.getProxyPropertyName(PROXY_PASSWORD_PROPERTY_SUFFIX), Strings.nullToEmpty((String)this.myPassword));
        }
        if (StringUtil.isEmpty((String)this.myExceptions)) {
            properties.remove(this.getProxyPropertyName(PROXY_EXCEPTIONS_PROPERTY_SUFFIX));
        } else {
            properties.setProperty(this.getProxyPropertyName(PROXY_EXCEPTIONS_PROPERTY_SUFFIX), this.myExceptions);
        }
    }

    @NotNull
    private String getProxyPropertyName(@NotNull String propertySuffix) {
        if (propertySuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertySuffix", "com/android/tools/idea/gradle/util/ProxySettings", "getProxyPropertyName"));
        }
        String string = "systemProp." + this.myProxyType + "." + propertySuffix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/ProxySettings", "getProxyPropertyName"));
        }
        return string;
    }

    @Nullable
    public String getHost() {
        return this.myHost;
    }

    public void setHost(@Nullable String host) {
        this.myHost = host;
    }

    @Nullable
    public String getExceptions() {
        return this.myExceptions;
    }

    public void setExceptions(@Nullable String exceptions) {
        this.myExceptions = exceptions;
    }

    @Nullable
    public String getUser() {
        return this.myUser;
    }

    public void setUser(@Nullable String user) {
        this.myUser = user;
    }

    @Nullable
    public String getPassword() {
        return this.myPassword;
    }

    public void setPassword(@Nullable String password) {
        this.myPassword = password;
    }

    public int getPort() {
        return this.myPort;
    }

    public void setPort(int port) {
        this.myPort = port;
    }

    public boolean equals(Object o) {
        if (o instanceof ProxySettings) {
            ProxySettings other = (ProxySettings)o;
            return this.myProxyType.equals(other.myProxyType) && ProxySettings.nullableEquals(this.myHost, other.myHost) && this.myPort == other.myPort && ProxySettings.nullableEquals(this.myExceptions, other.myExceptions) && ProxySettings.nullableEquals(this.myUser, other.myUser) && ProxySettings.nullableEquals(this.myPassword, other.myPassword);
        }
        return false;
    }

    private static boolean nullableEquals(@Nullable Object a, @Nullable Object b) {
        if (a != null) {
            return a.equals(b);
        }
        return b == null;
    }

    public void setProxyType(@NotNull String proxyType) {
        if (proxyType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxyType", "com/android/tools/idea/gradle/util/ProxySettings", "setProxyType"));
        }
        this.myProxyType = proxyType;
    }
}

