/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor;

import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.monitor.BaseMonitorView;
import com.android.tools.idea.monitor.MonitorPanel;
import com.android.tools.idea.monitor.cpu.CpuMonitorView;
import com.android.tools.idea.monitor.gpu.GpuMonitorView;
import com.android.tools.idea.monitor.memory.MemoryMonitorView;
import com.android.tools.idea.monitor.network.NetworkMonitorView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class MonitorContentFactory {
    public static void createMonitorContent(@NotNull Project project, @NotNull DeviceContext deviceContext, @NotNull RunnerLayoutUi layoutUi) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/monitor/MonitorContentFactory", "createMonitorContent"));
        }
        if (deviceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceContext", "com/android/tools/idea/monitor/MonitorContentFactory", "createMonitorContent"));
        }
        if (layoutUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutUi", "com/android/tools/idea/monitor/MonitorContentFactory", "createMonitorContent"));
        }
        BaseMonitorView[] monitors = new BaseMonitorView[]{new CpuMonitorView(project, deviceContext), new MemoryMonitorView(project, deviceContext), new NetworkMonitorView(project, deviceContext), new GpuMonitorView(project, deviceContext)};
        MonitorPanel monitorPanel = new MonitorPanel(monitors);
        JBScrollPane monitorScrollPane = new JBScrollPane(20, 31);
        monitorScrollPane.setViewportView((Component)monitorPanel);
        monitorScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        monitorScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        Content monitorContent = layoutUi.createContent("Monitors", (JComponent)monitorScrollPane, "Monitors", null, null);
        monitorContent.setCloseable(false);
        layoutUi.addContent(monitorContent);
    }
}

