/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor;

import com.android.tools.idea.monitor.BaseMonitorView;
import com.android.tools.idea.monitor.MinimizeAction;
import com.android.tools.idea.monitor.MonitorMoveAction;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.ui.components.JBLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class MonitorPanel
extends JPanel {
    @NotNull
    private List<BaseMonitorView> myMonitors;
    @NotNull
    private Map<Component, Component> myHiddenMonitorLookup;
    @NotNull
    private Map<Component, GridBagConstraints> myConstraintsLookup;

    MonitorPanel(@NotNull BaseMonitorView[] monitors) {
        if (monitors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "monitors", "com/android/tools/idea/monitor/MonitorPanel", "<init>"));
        }
        super(new GridBagLayout());
        this.myMonitors = Arrays.asList(monitors);
        Collections.sort(this.myMonitors, new Comparator<BaseMonitorView>(){

            @Override
            public int compare(BaseMonitorView left, BaseMonitorView right) {
                return left.getPosition() - right.getPosition();
            }
        });
        for (int i = 0; i < monitors.length; ++i) {
            monitors[i].setPosition(i);
        }
        JLabel titleLengthLabel = new JLabel();
        int largestLabelWidth = 0;
        for (BaseMonitorView monitor : monitors) {
            titleLengthLabel.setText(monitor.getTitleName());
            titleLengthLabel.setIcon(monitor.getTitleIcon());
            largestLabelWidth = Math.max(titleLengthLabel.getPreferredSize().width, largestLabelWidth);
        }
        this.myHiddenMonitorLookup = new HashMap<Component, Component>(monitors.length);
        this.myConstraintsLookup = new HashMap<Component, GridBagConstraints>(monitors.length);
        for (BaseMonitorView monitor : monitors) {
            ComponentWithActions monitorComponentWithActions = monitor.createComponent();
            ActionGroup actions = monitorComponentWithActions.getToolbarActions();
            assert (actions != null);
            this.layoutMonitor(monitorComponentWithActions.getComponent(), actions, monitor, largestLabelWidth);
        }
        JPanel spacerPanel = new JPanel();
        spacerPanel.setMinimumSize(new Dimension(0, 0));
        spacerPanel.setPreferredSize(new Dimension(0, 0));
        spacerPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.add((Component)spacerPanel, new GridBagConstraints(0, this.getComponentCount(), 1, 1, 1.0, 1.0E-9, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    boolean canMove(@NotNull BaseMonitorView monitor, int delta) {
        if (monitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "monitor", "com/android/tools/idea/monitor/MonitorPanel", "canMove"));
        }
        int destination = monitor.getPosition() + delta;
        return destination >= 0 && destination < this.myMonitors.size();
    }

    private static int getToolbarIndex(@NotNull BaseMonitorView monitor) {
        if (monitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "monitor", "com/android/tools/idea/monitor/MonitorPanel", "getToolbarIndex"));
        }
        return monitor.getPosition() * 2;
    }

    private GridBagLayout getMonitorLayout() {
        return (GridBagLayout)this.getLayout();
    }

    void moveMonitorUp(@NotNull BaseMonitorView monitor) {
        if (monitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "monitor", "com/android/tools/idea/monitor/MonitorPanel", "moveMonitorUp"));
        }
        if (!this.canMove(monitor, -1)) {
            assert (this.myMonitors.get(0) == monitor);
            return;
        }
        assert (this.myMonitors.contains(monitor));
        this.swapMonitors(this.myMonitors.get(monitor.getPosition() - 1), monitor);
    }

    void moveMonitorDown(@NotNull BaseMonitorView monitor) {
        if (monitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "monitor", "com/android/tools/idea/monitor/MonitorPanel", "moveMonitorDown"));
        }
        if (!this.canMove(monitor, 1)) {
            assert (this.myMonitors.get(this.myMonitors.size() - 1) == monitor);
            return;
        }
        assert (this.myMonitors.contains(monitor));
        this.swapMonitors(monitor, this.myMonitors.get(monitor.getPosition() + 1));
    }

    private void swapMonitors(@NotNull BaseMonitorView a, @NotNull BaseMonitorView b) {
        int baseIndexB;
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/android/tools/idea/monitor/MonitorPanel", "swapMonitors"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/android/tools/idea/monitor/MonitorPanel", "swapMonitors"));
        }
        assert (a != b);
        int baseIndexA = MonitorPanel.getToolbarIndex(a);
        if (baseIndexA > (baseIndexB = MonitorPanel.getToolbarIndex(b))) {
            int temp = baseIndexA;
            baseIndexA = baseIndexB;
            baseIndexB = temp;
        }
        Component toolbarB = this.getComponent(baseIndexB);
        GridBagConstraints toolbarBConstraints = this.myConstraintsLookup.get(toolbarB);
        Component monitorB = this.getComponent(baseIndexB + 1);
        GridBagConstraints monitorBConstraints = this.myConstraintsLookup.get(monitorB);
        this.remove(baseIndexB + 1);
        this.remove(baseIndexB);
        toolbarBConstraints.gridy = baseIndexA;
        monitorBConstraints.gridy = baseIndexA + 1;
        Component toolbarA = this.getComponent(baseIndexA);
        GridBagConstraints toolbarAConstraints = this.myConstraintsLookup.get(toolbarA);
        Component monitorA = this.getComponent(baseIndexA + 1);
        GridBagConstraints monitorAConstraints = this.myConstraintsLookup.get(monitorA);
        this.remove(baseIndexA + 1);
        this.remove(baseIndexA);
        toolbarAConstraints.gridy = baseIndexB;
        monitorAConstraints.gridy = baseIndexB + 1;
        this.add(toolbarB, toolbarBConstraints, baseIndexA);
        this.add(monitorB, monitorBConstraints, baseIndexA + 1);
        this.add(toolbarA, toolbarAConstraints, baseIndexB);
        this.add(monitorA, monitorAConstraints, baseIndexB + 1);
        int positionA = a.getPosition();
        int positionB = b.getPosition();
        a.setPosition(positionB);
        b.setPosition(positionA);
        this.myMonitors.set(positionA, b);
        this.myMonitors.set(positionB, a);
        assert (this.myMonitors.indexOf(a) == a.getPosition());
        assert (this.myMonitors.indexOf(b) == b.getPosition());
        this.revalidate();
        this.repaint();
    }

    void setMonitorMinimized(@NotNull BaseMonitorView monitor, boolean isMinimized) {
        if (monitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "monitor", "com/android/tools/idea/monitor/MonitorPanel", "setMonitorMinimized"));
        }
        int monitorIndex = MonitorPanel.getToolbarIndex(monitor) + 1;
        monitor.setIsMinimized(isMinimized);
        Component componentAtMonitorIndex = this.getComponent(monitorIndex);
        GridBagConstraints componentConstraintsAtMonitorIndex = this.getMonitorLayout().getConstraints(componentAtMonitorIndex);
        assert (this.myHiddenMonitorLookup.containsKey(componentAtMonitorIndex));
        Component complementComponent = this.myHiddenMonitorLookup.get(componentAtMonitorIndex);
        GridBagConstraints complementComponentConstraints = this.myConstraintsLookup.get(complementComponent);
        complementComponentConstraints.gridy = componentConstraintsAtMonitorIndex.gridy;
        this.remove(monitorIndex);
        this.add(complementComponent, complementComponentConstraints, monitorIndex);
        this.revalidate();
        this.repaint();
    }

    @NotNull
    private static GridBagConstraints getMinimizedPanelConstraints(@NotNull BaseMonitorView monitor) {
        if (monitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "monitor", "com/android/tools/idea/monitor/MonitorPanel", "getMinimizedPanelConstraints"));
        }
        GridBagConstraints minimizedPanelConstraints = new GridBagConstraints();
        minimizedPanelConstraints.fill = 1;
        minimizedPanelConstraints.weightx = 1.0;
        minimizedPanelConstraints.weighty = 0.0;
        minimizedPanelConstraints.gridx = 0;
        minimizedPanelConstraints.gridy = MonitorPanel.getToolbarIndex(monitor) + 1;
        GridBagConstraints gridBagConstraints = minimizedPanelConstraints;
        if (gridBagConstraints == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/MonitorPanel", "getMinimizedPanelConstraints"));
        }
        return gridBagConstraints;
    }

    @NotNull
    private static GridBagConstraints getMonitorConstraints(int componentIndex) {
        GridBagConstraints monitorComponentConstraints = new GridBagConstraints();
        monitorComponentConstraints.fill = 1;
        monitorComponentConstraints.weightx = 1.0;
        monitorComponentConstraints.weighty = 1.0;
        monitorComponentConstraints.gridx = 0;
        monitorComponentConstraints.gridy = componentIndex;
        GridBagConstraints gridBagConstraints = monitorComponentConstraints;
        if (gridBagConstraints == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/MonitorPanel", "getMonitorConstraints"));
        }
        return gridBagConstraints;
    }

    @NotNull
    private ActionToolbarImpl setupToolbar(@NotNull ActionGroup actions, @NotNull BaseMonitorView monitor) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/android/tools/idea/monitor/MonitorPanel", "setupToolbar"));
        }
        if (monitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "monitor", "com/android/tools/idea/monitor/MonitorPanel", "setupToolbar"));
        }
        DefaultActionGroup viewActions = new DefaultActionGroup();
        viewActions.addAll(actions);
        viewActions.add((AnAction)new MonitorMoveAction(this, monitor, -1));
        viewActions.add((AnAction)new MonitorMoveAction(this, monitor, 1));
        viewActions.add((AnAction)new MinimizeAction(this, monitor));
        ActionToolbarImpl toolbar = new ActionToolbarImpl("unknown", (ActionGroup)viewActions, true, false, DataManager.getInstance(), ActionManagerEx.getInstanceEx(), KeymapManagerEx.getInstanceEx());
        toolbar.setBorder(BorderFactory.createEmptyBorder());
        toolbar.setMinimumSize(new Dimension(0, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.height));
        toolbar.setPreferredSize(new Dimension(Integer.MAX_VALUE, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.height));
        toolbar.setMaximumSize(toolbar.getPreferredSize());
        ActionToolbarImpl actionToolbarImpl = toolbar;
        if (actionToolbarImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/MonitorPanel", "setupToolbar"));
        }
        return actionToolbarImpl;
    }

    private void layoutMonitor(@NotNull JComponent monitorComponent, @NotNull ActionGroup actions, @NotNull BaseMonitorView monitor, int titleSize) {
        if (monitorComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "monitorComponent", "com/android/tools/idea/monitor/MonitorPanel", "layoutMonitor"));
        }
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/android/tools/idea/monitor/MonitorPanel", "layoutMonitor"));
        }
        if (monitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "monitor", "com/android/tools/idea/monitor/MonitorPanel", "layoutMonitor"));
        }
        monitorComponent.setMinimumSize(new Dimension(100, 100));
        monitorComponent.setPreferredSize(new Dimension(Integer.MAX_VALUE, 100));
        int toolbarIndex = MonitorPanel.getToolbarIndex(monitor);
        assert (toolbarIndex == this.getComponentCount());
        int componentIndex = toolbarIndex + 1;
        JPanel minimizedPanel = new JPanel();
        minimizedPanel.setBackground(monitor.getViewBackgroundColor());
        minimizedPanel.setMinimumSize(new Dimension(Integer.MAX_VALUE, 2));
        minimizedPanel.setPreferredSize(minimizedPanel.getMinimumSize());
        minimizedPanel.setMaximumSize(minimizedPanel.getMinimumSize());
        this.myHiddenMonitorLookup.put(monitorComponent, minimizedPanel);
        this.myHiddenMonitorLookup.put(minimizedPanel, monitorComponent);
        ActionToolbarImpl toolbar = this.setupToolbar(actions, monitor);
        JBLabel titleLabel = new JBLabel(monitor.getTitleName(), monitor.getTitleIcon(), 2);
        Border border = BorderFactory.createEmptyBorder(0, 5, 0, 20);
        titleLabel.setBorder(border);
        titleLabel.setBackground(toolbar.getBackground());
        Insets borderInsets = border.getBorderInsets((Component)titleLabel);
        titleLabel.setMinimumSize(new Dimension(titleSize + borderInsets.left + borderInsets.right, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.height));
        titleLabel.setPreferredSize(titleLabel.getMinimumSize());
        titleLabel.setMaximumSize(titleLabel.getMinimumSize());
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.add((Component)titleLabel, "West");
        titlePanel.add((Component)toolbar, "Center");
        GridBagConstraints titlePanelConstraints = new GridBagConstraints(0, toolbarIndex, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)titlePanel, titlePanelConstraints);
        GridBagConstraints monitorComponentConstraints = MonitorPanel.getMonitorConstraints(componentIndex);
        GridBagConstraints minimizedPanelConstraints = MonitorPanel.getMinimizedPanelConstraints(monitor);
        this.myConstraintsLookup.put(minimizedPanel, minimizedPanelConstraints);
        if (monitor.getIsMinimized()) {
            this.add((Component)minimizedPanel, minimizedPanelConstraints);
        } else {
            this.add((Component)monitorComponent, monitorComponentConstraints);
        }
        this.myConstraintsLookup.put(monitorComponent, monitorComponentConstraints);
        this.myConstraintsLookup.put(titlePanel, titlePanelConstraints);
    }
}

