/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidResFileNode;
import com.android.tools.idea.navigator.nodes.AndroidResGroupNode;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResFolderTypeNode
extends ProjectViewNode<List<PsiDirectory>>
implements DirectoryGroupNode {
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ResourceFolderType myFolderType;
    @NotNull
    private final AndroidProjectViewPane myProjectViewPane;

    public AndroidResFolderTypeNode(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull List<PsiDirectory> folders, @NotNull ViewSettings settings, @NotNull ResourceFolderType folderType, @NotNull AndroidProjectViewPane projectViewPane) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/navigator/nodes/AndroidResFolderTypeNode", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/navigator/nodes/AndroidResFolderTypeNode", "<init>"));
        }
        if (folders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folders", "com/android/tools/idea/navigator/nodes/AndroidResFolderTypeNode", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/android/tools/idea/navigator/nodes/AndroidResFolderTypeNode", "<init>"));
        }
        if (folderType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderType", "com/android/tools/idea/navigator/nodes/AndroidResFolderTypeNode", "<init>"));
        }
        if (projectViewPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectViewPane", "com/android/tools/idea/navigator/nodes/AndroidResFolderTypeNode", "<init>"));
        }
        super(project, folders, settings);
        this.myFacet = facet;
        this.myFolderType = folderType;
        this.myProjectViewPane = projectViewPane;
    }

    @Override
    @NotNull
    public PsiDirectory[] getDirectories() {
        List dirs = (List)this.getValue();
        PsiDirectory[] psiDirectoryArray = dirs.toArray(new PsiDirectory[dirs.size()]);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidResFolderTypeNode", "getDirectories"));
        }
        return psiDirectoryArray;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/navigator/nodes/AndroidResFolderTypeNode", "contains"));
        }
        for (PsiDirectory psiDirectory : (List)this.getValue()) {
            VirtualFile folder = psiDirectory.getVirtualFile();
            if (!VfsUtilCore.isAncestor((VirtualFile)folder, (VirtualFile)file, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        List folders = (List)this.getValue();
        HashMultimap multimap = HashMultimap.create();
        for (PsiDirectory res : folders) {
            for (PsiFile file : res.getFiles()) {
                String resName = file.getName();
                multimap.put((Object)resName, (Object)file);
            }
        }
        ArrayList children = Lists.newArrayListWithExpectedSize((int)multimap.size());
        for (String resName : multimap.keySet()) {
            ArrayList files = Lists.newArrayList((Iterable)multimap.get((Object)resName));
            if (files.size() > 1) {
                children.add(new AndroidResGroupNode(this.myProject, this.myFacet, files, resName, this.getSettings()));
                continue;
            }
            children.add(new AndroidResFileNode(this.myProject, (PsiFile)files.get(0), this.getSettings(), this.myFacet));
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidResFolderTypeNode", "getChildren"));
        }
        return arrayList;
    }

    protected void update(PresentationData presentation) {
        presentation.addText(this.myFolderType.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
        presentation.setPresentableText(this.myFolderType.getName());
    }

    @Nullable
    public Comparable getSortKey() {
        return this.myFolderType;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.myFolderType;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.myFolderType.getName();
    }
}

