/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.gradle.facet.NativeAndroidGradleFacet;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAndroidSourceTypeNode
extends ProjectViewNode<Module>
implements DirectoryGroupNode {
    private final AndroidSourceType mySourceType;

    public NativeAndroidSourceTypeNode(@NotNull Project project, @NotNull Module module, @NotNull ViewSettings settings, @NotNull AndroidSourceType type) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/navigator/nodes/NativeAndroidSourceTypeNode", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/navigator/nodes/NativeAndroidSourceTypeNode", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/android/tools/idea/navigator/nodes/NativeAndroidSourceTypeNode", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/navigator/nodes/NativeAndroidSourceTypeNode", "<init>"));
        }
        super(project, (Object)module, settings);
        this.mySourceType = type;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Collection<VirtualFile> sourceFolders = this.getSourceFolders();
        ArrayList children = Lists.newArrayListWithExpectedSize((int)sourceFolders.size());
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ProjectViewDirectoryHelper directoryHelper = ProjectViewDirectoryHelper.getInstance((Project)this.myProject);
        for (VirtualFile file : sourceFolders) {
            PsiDirectory dir = psiManager.findDirectory(file);
            if (dir == null) continue;
            children.addAll(directoryHelper.getDirectoryChildren(dir, this.getSettings(), true));
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/NativeAndroidSourceTypeNode", "getChildren"));
        }
        return arrayList;
    }

    @NotNull
    private Collection<VirtualFile> getSourceFolders() {
        Module module = (Module)this.getValue();
        NativeAndroidGradleFacet facet = NativeAndroidGradleFacet.getInstance(module);
        if (facet == null || facet.getNativeAndroidGradleModel() == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/NativeAndroidSourceTypeNode", "getSourceFolders"));
            }
            return list;
        }
        List<VirtualFile> list = this.mySourceType.getSources(IdeaSourceProvider.create(facet));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/NativeAndroidSourceTypeNode", "getSourceFolders"));
        }
        return list;
    }

    protected void update(PresentationData presentation) {
        presentation.addText(this.mySourceType.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon = this.mySourceType.getIcon();
        if (icon != null) {
            presentation.setIcon(icon);
        }
        presentation.setPresentableText(this.mySourceType.getName());
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/navigator/nodes/NativeAndroidSourceTypeNode", "contains"));
        }
        for (VirtualFile folder : this.getSourceFolders()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)folder, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.mySourceType;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.mySourceType;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.mySourceType.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NativeAndroidSourceTypeNode that = (NativeAndroidSourceTypeNode)o;
        return this.mySourceType == that.mySourceType;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mySourceType.hashCode();
        return result;
    }

    @Override
    @NotNull
    public PsiDirectory[] getDirectories() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        Collection<VirtualFile> sourceFolders = this.getSourceFolders();
        ArrayList psiDirectories = Lists.newArrayListWithExpectedSize((int)sourceFolders.size());
        for (VirtualFile f : sourceFolders) {
            PsiDirectory dir = psiManager.findDirectory(f);
            if (dir == null) continue;
            psiDirectories.add(dir);
        }
        PsiDirectory[] psiDirectoryArray = psiDirectories.toArray(new PsiDirectory[psiDirectories.size()]);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/NativeAndroidSourceTypeNode", "getDirectories"));
        }
        return psiDirectoryArray;
    }
}

