/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.ide.common.vectordrawable.VdIcon;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class IconPicker
extends JPanel {
    private static final Logger LOG = Logger.getInstance(IconPicker.class);
    private static final int COLUMN_NUMBER = 6;
    private static final String MATERIAL_DESIGN_ICONS_PATH = "images/material_design_icons/";
    private final List<VdIcon> mIconList = new ArrayList<VdIcon>();
    private VdIcon mSelectedIcon = null;
    private JBColor mIconBackground = new JBColor(UIUtil.getListBackground().getRGB(), 0x6F6F6F);
    private static final String[] mIconCategories = new String[]{"All", "Action", "Alert", "Av", "Communication", "Content", "Device", "Editor", "File", "Hardware", "Image", "Maps", "Navigation", "Notification", "Social", "Toggle"};
    private final Multimap<String, VdIcon> mAllIconCategoryMap = TreeMultimap.create();
    private AbstractTableModel mModel = new AbstractTableModel(){

        @Override
        public String getColumnName(int column) {
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return VdIcon.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            int index = rowIndex * 6 + columnIndex;
            if (index < 0) {
                return null;
            }
            return IconPicker.this.mIconList.size() > index ? IconPicker.this.mIconList.get(index) : null;
        }

        @Override
        public int getRowCount() {
            return IconPicker.this.mIconList.size() / 6 + (IconPicker.this.mIconList.size() % 6 == 0 ? 0 : 1);
        }

        @Override
        public int getColumnCount() {
            return 6;
        }
    };
    private DefaultTableCellRenderer mTableRenderer = new DefaultTableCellRenderer(){

        @Override
        public void setValue(Object value) {
            if (value == null) {
                this.setToolTipText(null);
                this.setText("");
                this.setIcon(null);
            } else {
                VdIcon icon = (VdIcon)value;
                this.setToolTipText(icon.getName());
                this.setIcon((Icon)icon);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table.getValueAt(row, column) == null) {
                Component cell = super.getTableCellRendererComponent(table, value, false, false, row, column);
                cell.setFocusable(false);
                return cell;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    };
    private JBTable mTable = new JBTable((TableModel)this.mModel);
    private JBScrollPane mTablePane = new JBScrollPane((Component)this.mTable);

    public IconPicker(final DialogBuilder builder) {
        super(new BorderLayout(20, 20));
        this.mTableRenderer.setBackground((Color)this.mIconBackground);
        this.mTable.setDefaultRenderer(VdIcon.class, (TableCellRenderer)this.mTableRenderer);
        this.mTable.setRowHeight(48);
        this.mTable.setSelectionMode(0);
        this.mTable.setCellSelectionEnabled(true);
        this.add((Component)this.mTablePane);
        final JBList categoryList = new JBList((Object[])mIconCategories);
        JBScrollPane mCategoryPane = new JBScrollPane((Component)categoryList);
        JPanel p = new JPanel(new BorderLayout());
        this.add((Component)p, "West");
        p.add((Component)mCategoryPane);
        HyperlinkLabel licenseLabel = new HyperlinkLabel();
        licenseLabel.setHyperlinkText("These icons are available under the ", "CC-BY license", "");
        licenseLabel.setHyperlinkTarget("https://creativecommons.org/licenses/by/4.0/");
        this.add((Component)licenseLabel, "South");
        ListSelectionModel selModel = this.mTable.getSelectionModel();
        this.mTable.getColumnModel().setColumnSelectionAllowed(true);
        this.mTable.setGridColor((Color)this.mIconBackground);
        this.mTable.setIntercellSpacing(new Dimension(0, 0));
        this.mTable.setRowMargin(0);
        ListSelectionListener listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = IconPicker.this.mTable.getSelectedRow();
                int col = IconPicker.this.mTable.getSelectedColumn();
                VdIcon icon = (VdIcon)IconPicker.this.mModel.getValueAt(row, col);
                IconPicker.this.mSelectedIcon = icon;
                builder.setOkActionEnabled(icon != null);
            }
        };
        selModel.addListSelectionListener(listener);
        ListSelectionModel colSelModel = this.mTable.getColumnModel().getSelectionModel();
        colSelModel.addListSelectionListener(listener);
        categoryList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                IconPicker.this.updateIconList((String)categoryList.getSelectedValue());
            }
        });
        categoryList.setSelectedIndex(0);
        this.loadInternalDrawables();
        selModel.setSelectionMode(0);
        selModel.setSelectionInterval(0, 0);
        this.mTable.setColumnSelectionInterval(0, 0);
        this.mTable.requestFocusInWindow();
    }

    public VdIcon getSelectIcon() {
        return this.mSelectedIcon;
    }

    private void updateIconList(String categoryName) {
        this.mIconList.clear();
        if (this.mAllIconCategoryMap.containsKey((Object)categoryName)) {
            this.mIconList.addAll(this.mAllIconCategoryMap.get((Object)categoryName));
            this.mTable.getColumnModel().setColumnSelectionAllowed(true);
        } else {
            this.mIconList.addAll(this.mAllIconCategoryMap.values());
        }
        this.mModel.fireTableDataChanged();
        this.mTable.setColumnSelectionInterval(0, 0);
        this.mTable.getSelectionModel().setSelectionInterval(0, 0);
    }

    private void loadInternalDrawables() {
        for (int i = 1; i < mIconCategories.length; ++i) {
            String categoryName = mIconCategories[i];
            String categoryNameLowerCase = categoryName.toLowerCase(Locale.ENGLISH);
            String fullDirName = MATERIAL_DESIGN_ICONS_PATH + categoryNameLowerCase + '/';
            Iterator iter = GraphicGenerator.getResourcesNames((String)fullDirName, (String)".xml");
            while (iter.hasNext()) {
                String iconName = (String)iter.next();
                URL url = GraphicGenerator.class.getClassLoader().getResource(fullDirName + iconName);
                VdIcon icon = new VdIcon(url);
                this.mAllIconCategoryMap.put((Object)categoryName, (Object)icon);
            }
        }
        this.mIconList.addAll(this.mAllIconCategoryMap.values());
        this.mModel.fireTableDataChanged();
    }
}

