/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template.components;

import com.android.tools.idea.npw.template.components.ParameterComponentProvider;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.ui.ApiComboBoxItem;
import com.android.tools.idea.ui.properties.ObservableProperty;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class EnumComboProvider
extends ParameterComponentProvider<JComboBox> {
    public EnumComboProvider(@NotNull Parameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/npw/template/components/EnumComboProvider", "<init>"));
        }
        super(parameter);
    }

    private static ApiComboBoxItem<String> createItemForOption(@NotNull Parameter parameter, @NotNull Element option) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/npw/template/components/EnumComboProvider", "createItemForOption"));
        }
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/android/tools/idea/npw/template/components/EnumComboProvider", "createItemForOption"));
        }
        String optionId = option.getAttribute("id");
        assert (optionId != null && !optionId.isEmpty()) : "id";
        NodeList childNodes = option.getChildNodes();
        assert (childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3);
        String optionLabel = childNodes.item(0).getNodeValue().trim();
        int minSdk = EnumComboProvider.getIntegerOptionValue(option, "minApi", parameter.name, 1);
        int minBuildApi = EnumComboProvider.getIntegerOptionValue(option, "minBuildApi", parameter.name, 1);
        return new ApiComboBoxItem<String>(optionId, optionLabel, minSdk, minBuildApi);
    }

    private static int getIntegerOptionValue(@NotNull Element option, String attribute, @Nullable String parameterName, int defaultValue) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/android/tools/idea/npw/template/components/EnumComboProvider", "getIntegerOptionValue"));
        }
        String stringValue = option.getAttribute(attribute);
        try {
            return StringUtil.isEmpty((String)stringValue) ? defaultValue : Integer.parseInt(stringValue);
        }
        catch (Exception e) {
            EnumComboProvider.getLog().warn(String.format("Invalid %1$s value (%2$s) for option %3$s in parameter %4$s", attribute, stringValue, option.getAttribute("id"), parameterName), (Throwable)e);
            return defaultValue;
        }
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(EnumComboProvider.class);
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/components/EnumComboProvider", "getLog"));
        }
        return logger;
    }

    @Override
    @NotNull
    protected JComboBox createComponent(@NotNull Parameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/npw/template/components/EnumComboProvider", "createComponent"));
        }
        List<Element> options = parameter.getOptions();
        DefaultComboBoxModel<ApiComboBoxItem<String>> comboBoxModel = new DefaultComboBoxModel<ApiComboBoxItem<String>>();
        assert (!options.isEmpty());
        for (Element option : options) {
            comboBoxModel.addElement(EnumComboProvider.createItemForOption(parameter, option));
        }
        JComboBox jComboBox = new JComboBox(comboBoxModel);
        if (jComboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/components/EnumComboProvider", "createComponent"));
        }
        return jComboBox;
    }

    @Override
    @Nullable
    public ObservableProperty<?> createProperty(@NotNull JComboBox comboBox) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/android/tools/idea/npw/template/components/EnumComboProvider", "createProperty"));
        }
        return new ApiComboBoxTextProperty(comboBox);
    }

    private static class ApiComboBoxTextProperty
    extends ObservableProperty<String>
    implements ActionListener {
        @NotNull
        private final JComboBox myComboBox;

        public ApiComboBoxTextProperty(@NotNull JComboBox comboBox) {
            if (comboBox == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/android/tools/idea/npw/template/components/EnumComboProvider$ApiComboBoxTextProperty", "<init>"));
            }
            this.myComboBox = comboBox;
            this.myComboBox.addActionListener(this);
        }

        @Override
        protected void setDirectly(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/npw/template/components/EnumComboProvider$ApiComboBoxTextProperty", "setDirectly"));
            }
            int index = -1;
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.myComboBox.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                ApiComboBoxItem item = (ApiComboBoxItem)model.getElementAt(i);
                if (!value.equals(item.getData())) continue;
                index = i;
                break;
            }
            this.myComboBox.setSelectedIndex(index);
        }

        @Override
        @NotNull
        public String get() {
            ApiComboBoxItem item = (ApiComboBoxItem)this.myComboBox.getSelectedItem();
            String string = item != null ? (String)item.getData() : "";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/components/EnumComboProvider$ApiComboBoxTextProperty", "get"));
            }
            return string;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.notifyInvalidated();
        }
    }
}

