/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.AttributeSnapshot;
import com.google.common.collect.Lists;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagSnapshot {
    @Nullable
    public final String namespace;
    @NotNull
    public final String tagName;
    @Nullable
    public final XmlTag tag;
    @Nullable
    public final String prefix;
    @Nullable
    private TagSnapshot myNext;
    @NotNull
    public List<TagSnapshot> children;
    @NotNull
    public List<AttributeSnapshot> attributes;

    private TagSnapshot(@Nullable XmlTag tag, @Nullable String tagName, @Nullable String prefix, @Nullable String namespace, @NotNull List<AttributeSnapshot> attributes, @NotNull List<TagSnapshot> children) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/rendering/TagSnapshot", "<init>"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/android/tools/idea/rendering/TagSnapshot", "<init>"));
        }
        this.tagName = tagName != null ? tagName : "?";
        this.prefix = prefix == null || prefix.isEmpty() ? null : prefix;
        this.namespace = namespace;
        this.tag = tag;
        this.attributes = attributes;
        this.children = children;
    }

    public static TagSnapshot createSyntheticTag(@Nullable XmlTag tag, @Nullable String tagName, @Nullable String prefix, @Nullable String namespace, @NotNull List<AttributeSnapshot> attributes, @NotNull List<TagSnapshot> children) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/rendering/TagSnapshot", "createSyntheticTag"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/android/tools/idea/rendering/TagSnapshot", "createSyntheticTag"));
        }
        return new TagSnapshot(tag, tagName, prefix, namespace, attributes, children);
    }

    @NotNull
    public static TagSnapshot createTagSnapshot(@NotNull XmlTag tag) {
        ArrayList children;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/rendering/TagSnapshot", "createTagSnapshot"));
        }
        List<AttributeSnapshot> attributes = AttributeSnapshot.createAttributesForTag(tag);
        XmlTag[] subTags = tag.getSubTags();
        if (subTags.length > 0) {
            TagSnapshot last = null;
            children = Lists.newArrayListWithExpectedSize((int)subTags.length);
            for (XmlTag subTag : subTags) {
                TagSnapshot child = TagSnapshot.createTagSnapshot(subTag);
                children.add(child);
                if (last != null) {
                    last.myNext = child;
                }
                last = child;
            }
        } else {
            children = Collections.emptyList();
        }
        TagSnapshot tagSnapshot = new TagSnapshot(tag, tag.getName(), tag.getNamespacePrefix(), tag.getNamespace(), attributes, children);
        if (tagSnapshot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/TagSnapshot", "createTagSnapshot"));
        }
        return tagSnapshot;
    }

    @Nullable
    public String getAttribute(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/rendering/TagSnapshot", "getAttribute"));
        }
        return this.getAttribute(name, null);
    }

    @Nullable
    public String getAttribute(@NotNull String name, @Nullable String namespace) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/rendering/TagSnapshot", "getAttribute"));
        }
        for (AttributeSnapshot attribute : this.attributes) {
            if (!name.equals(attribute.name) || namespace != null && !namespace.equals(attribute.namespace)) continue;
            return attribute.value;
        }
        return null;
    }

    public void setAttribute(@NotNull String name, @Nullable String namespace, @Nullable String prefix, @Nullable String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/rendering/TagSnapshot", "setAttribute"));
        }
        for (AttributeSnapshot attribute : this.attributes) {
            if (!name.equals(attribute.name) || namespace != null && !namespace.equals(attribute.namespace)) continue;
            this.attributes.remove(attribute);
            break;
        }
        if (value != null) {
            if (this.attributes.isEmpty()) {
                this.attributes = Lists.newArrayList();
            }
            this.attributes.add(new AttributeSnapshot(namespace, prefix, name, value));
        }
    }

    @Nullable
    public TagSnapshot getNextSibling() {
        return this.myNext;
    }

    public String toString() {
        return "TagSnapshot{" + this.tagName + ", attributes=" + this.attributes + ", children=\n" + this.children + "\n}";
    }
}

