/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenDefaultActivityLocator
extends ActivityLocator {
    private final AndroidFacet myFacet;

    public MavenDefaultActivityLocator(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/activity/MavenDefaultActivityLocator", "<init>"));
        }
        this.myFacet = facet;
    }

    @Override
    public void validate() throws ActivityLocator.ActivityLocatorException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String getQualifiedActivityName(@NotNull IDevice device) throws ActivityLocator.ActivityLocatorException {
        Manifest manifest;
        Pair<File, String> pair;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/activity/MavenDefaultActivityLocator", "getQualifiedActivityName"));
        }
        File manifestCopy = null;
        try {
            pair = ApkProviderUtil.getCopyOfCompilerManifestFile(this.myFacet);
        }
        catch (IOException e) {
            throw new ActivityLocator.ActivityLocatorException("Error while obtaining compiler manifest file", e);
        }
        manifestCopy = pair != null ? (File)pair.getFirst() : null;
        VirtualFile manifestVFile = manifestCopy != null ? LocalFileSystem.getInstance().findFileByIoFile(manifestCopy) : null;
        Manifest manifest2 = manifest = manifestVFile == null ? null : AndroidUtils.loadDomElement(this.myFacet.getModule(), manifestVFile, Manifest.class);
        if (manifest == null) {
            throw new ActivityLocator.ActivityLocatorException("Cannot find AndroidManifest.xml file");
        }
        String string = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                return DefaultActivityLocator.getDefaultLauncherActivityName(MavenDefaultActivityLocator.this.myFacet.getModule().getProject(), manifest);
            }
        });
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/activity/MavenDefaultActivityLocator", "getQualifiedActivityName"));
        }
        return string2;
        finally {
            if (manifestCopy != null) {
                FileUtil.delete((File)manifestCopy.getParentFile());
            }
        }
    }
}

