/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorNotificationPanel;
import com.android.tools.idea.avdmanager.AvdEditWizard;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidDeviceRenderer;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DevicePickerEntry;
import com.android.tools.idea.run.DevicePickerListModel;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.util.LaunchUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;

public class DevicePicker
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener,
Disposable,
ActionListener,
ListSelectionListener {
    private static final int UPDATE_DELAY_MILLIS = 250;
    private static final String DEVICE_PICKER_LAST_SELECTION = "device.picker.selection";
    private static final TIntObjectHashMap<Set<String>> ourSelectionsPerConfig = new TIntObjectHashMap();
    private JPanel myPanel;
    private JButton myCreateEmulatorButton;
    private HyperlinkLabel myHelpHyperlink;
    private JScrollPane myScrollPane;
    private JPanel myNotificationPanel;
    private JBList myDevicesList;
    private int myDeviceCount;
    private int myErrorGen;
    @NotNull
    private final AndroidFacet myFacet;
    private final int myRunContextId;
    @NotNull
    private final DevicePickerListModel myModel;
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    private final LaunchCompatibilityChecker myCompatibilityChecker;
    private final ListSpeedSearch mySpeedSearch;
    private List<AvdInfo> myAvdInfos;

    public DevicePicker(@NotNull Disposable parent, int runContextId, final @NotNull AndroidFacet facet, @NotNull DeviceCount deviceCount) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/run/editor/DevicePicker", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/editor/DevicePicker", "<init>"));
        }
        if (deviceCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceCount", "com/android/tools/idea/run/editor/DevicePicker", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myAvdInfos = Lists.newArrayList();
        this.myRunContextId = runContextId;
        this.myFacet = facet;
        this.myHelpHyperlink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                DevicePicker.launchDiagnostics(facet.getModule().getProject());
            }
        });
        this.myCompatibilityChecker = DevicePicker.createChecker(facet);
        this.mySpeedSearch = new ListSpeedSearch((JList)this.myDevicesList){

            protected String getElementText(Object element) {
                DevicePickerEntry entry;
                if (element instanceof DevicePickerEntry && !(entry = (DevicePickerEntry)element).isMarker()) {
                    AndroidDevice device = entry.getAndroidDevice();
                    return device.getName();
                }
                return "";
            }
        };
        this.myModel = new DevicePickerListModel();
        this.myDevicesList.setModel((ListModel)this.myModel);
        this.myDevicesList.setCellRenderer((ListCellRenderer)((Object)new AndroidDeviceRenderer(this.myCompatibilityChecker, (SpeedSearchBase)this.mySpeedSearch)));
        this.myDevicesList.setSelectionMode(DevicePicker.getListSelectionMode(deviceCount));
        this.myDevicesList.addKeyListener((KeyListener)new MyListKeyListener(this.mySpeedSearch));
        this.myDevicesList.addListSelectionListener((ListSelectionListener)this);
        this.myNotificationPanel.setLayout(new BoxLayout(this.myNotificationPanel, 1));
        this.myCreateEmulatorButton.addActionListener(this);
        this.myUpdateQueue = new MergingUpdateQueue("android.device.chooser", 250, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.postUpdate();
        this.refreshAvds(null);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    private static LaunchCompatibilityChecker createChecker(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/editor/DevicePicker", "createChecker"));
        }
        AndroidVersion minSdkVersion = AndroidModuleInfo.get(facet).getRuntimeMinSdkVersion();
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            throw new IllegalStateException("Android platform not set for module: " + facet.getModule().getName());
        }
        EnumSet<IDevice.HardwareFeature> requiredHardwareFeatures = LaunchUtils.isWatchFeatureRequired(facet) ? EnumSet.of(IDevice.HardwareFeature.WATCH) : EnumSet.noneOf(IDevice.HardwareFeature.class);
        return new LaunchCompatibilityChecker(minSdkVersion, platform.getTarget(), requiredHardwareFeatures);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDevicesList;
    }

    private void createUIComponents() {
        this.myDevicesList = new JBList();
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myDevicesList);
        this.myHelpHyperlink = new HyperlinkLabel("Don't see your device?");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myCreateEmulatorButton) {
            AvdEditWizard wizard = new AvdEditWizard(this.myPanel, this.myFacet.getModule().getProject(), this.myFacet.getModule(), null, false);
            wizard.init();
            wizard.showAndGet();
            AvdInfo createdAvd = wizard.getCreatedAvd();
            this.refreshAvds(createdAvd);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.myDevicesList) {
            Set<String> selectedSerials = DevicePicker.getSelectedSerials(this.myDevicesList.getSelectedValues());
            ourSelectionsPerConfig.put(this.myRunContextId, selectedSerials);
            DevicePicker.saveSelectionForProject(this.myFacet.getModule().getProject(), selectedSerials);
        }
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        this.postUpdate();
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/editor/DevicePicker", "deviceConnected"));
        }
        this.postUpdate();
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/editor/DevicePicker", "deviceDisconnected"));
        }
        this.postUpdate();
    }

    public void deviceChanged(IDevice device, int changeMask) {
        this.postUpdate();
    }

    public void refreshAvds(final AvdInfo avdToSelect) {
        this.myDevicesList.setPaintBusy(true);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                final List<AvdInfo> avdInfos = AvdManagerConnection.getDefaultAvdManagerConnection().getAvds(true);
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DevicePicker.this.myAvdInfos = avdInfos;
                        DevicePicker.this.updateModel();
                        DevicePicker.this.myDevicesList.setPaintBusy(false);
                        if (avdToSelect != null) {
                            DevicePicker.this.selectAvd(avdToSelect);
                        }
                    }
                });
            }
        });
    }

    private void updateErrorCheck() {
        ++this.myErrorGen;
        this.myNotificationPanel.removeAll();
        if (this.myDeviceCount == 0) {
            EditorNotificationPanel panel = new EditorNotificationPanel();
            panel.setText("No USB devices or running emulators detected");
            panel.createActionLabel("Troubleshoot", new Runnable(){

                @Override
                public void run() {
                    DevicePicker.launchDiagnostics(null);
                }
            });
            this.myNotificationPanel.add((Component)panel);
        }
        if (!this.myAvdInfos.isEmpty()) {
            final int currentErrorGen = this.myErrorGen;
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    final AccelerationErrorCode error = AvdManagerConnection.getDefaultAvdManagerConnection().checkAcceration();
                    if (error != AccelerationErrorCode.ALREADY_INSTALLED) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (DevicePicker.this.myErrorGen != currentErrorGen) {
                                    return;
                                }
                                DevicePicker.this.myNotificationPanel.add((Component)((Object)new AccelerationErrorNotificationPanel(error, DevicePicker.this.myFacet.getModule().getProject(), new Runnable(){

                                    @Override
                                    public void run() {
                                        DevicePicker.this.updateErrorCheck();
                                    }
                                })));
                                DevicePicker.this.myPanel.revalidate();
                                DevicePicker.this.myPanel.repaint();
                            }
                        });
                    }
                }
            });
        }
    }

    private void postUpdate() {
        this.myUpdateQueue.queue(new Update("updateDevicePickerModel"){

            public void run() {
                DevicePicker.this.updateModel();
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
    }

    private void selectAvd(@NotNull AvdInfo avdToSelect) {
        if (avdToSelect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdToSelect", "com/android/tools/idea/run/editor/DevicePicker", "selectAvd"));
        }
        String serial = new LaunchableAndroidDevice(avdToSelect).getSerial();
        List<DevicePickerEntry> items = this.myModel.getItems();
        for (int i = 0; i < items.size(); ++i) {
            DevicePickerEntry entry = items.get(i);
            if (entry.isMarker()) continue;
            AndroidDevice device = entry.getAndroidDevice();
            assert (device != null) : "Non marker entry cannot be null";
            if (!serial.equals(device.getSerial())) continue;
            this.myDevicesList.setSelectedIndex(i);
            return;
        }
    }

    private void updateModel() {
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge == null || !bridge.isConnected()) {
            return;
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    DevicePicker.this.updateModel();
                }
            });
            return;
        }
        Set<String> selectedSerials = DevicePicker.getSelectedSerials(this.myDevicesList.getSelectedValues());
        ArrayList connectedDevices = Lists.newArrayList((Object[])bridge.getDevices());
        this.myModel.reset(connectedDevices, this.myAvdInfos);
        this.myDeviceCount = connectedDevices.size();
        if (selectedSerials.isEmpty()) {
            selectedSerials = this.getDefaultSelection();
        }
        this.myDevicesList.setSelectedIndices(DevicePicker.getIndices(this.myModel.getItems(), selectedSerials));
        this.myHelpHyperlink.setVisible(!connectedDevices.isEmpty());
        this.updateErrorCheck();
    }

    @NotNull
    private static int[] getIndices(@NotNull List<DevicePickerEntry> items, @NotNull Set<String> selectedSerials) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/android/tools/idea/run/editor/DevicePicker", "getIndices"));
        }
        if (selectedSerials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedSerials", "com/android/tools/idea/run/editor/DevicePicker", "getIndices"));
        }
        TIntArrayList list = new TIntArrayList(selectedSerials.size());
        for (int i = 0; i < items.size(); ++i) {
            DevicePickerEntry entry = items.get(i);
            if (entry.isMarker()) continue;
            AndroidDevice androidDevice = entry.getAndroidDevice();
            assert (androidDevice != null) : "An entry in the device picker must be either a marker or an AndroidDevice, got null";
            if (!selectedSerials.contains(androidDevice.getSerial())) continue;
            list.add(i);
        }
        int[] nArray = list.toNativeArray();
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/DevicePicker", "getIndices"));
        }
        return nArray;
    }

    @NotNull
    private static Set<String> getSelectedSerials(@NotNull Object[] selectedValues) {
        if (selectedValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedValues", "com/android/tools/idea/run/editor/DevicePicker", "getSelectedSerials"));
        }
        HashSet selection = Sets.newHashSet();
        for (Object o : selectedValues) {
            AndroidDevice device;
            if (!(o instanceof DevicePickerEntry) || (device = ((DevicePickerEntry)o).getAndroidDevice()) == null) continue;
            selection.add(device.getSerial());
        }
        HashSet hashSet = selection;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/DevicePicker", "getSelectedSerials"));
        }
        return hashSet;
    }

    @NotNull
    private Set<String> getDefaultSelection() {
        int[] indices;
        Set<String> lastSelection = (Set<String>)ourSelectionsPerConfig.get(this.myRunContextId);
        if (lastSelection == null || lastSelection.isEmpty()) {
            lastSelection = DevicePicker.getLastSelectionForProject(this.myFacet.getModule().getProject());
        }
        if (!lastSelection.isEmpty() && (indices = DevicePicker.getIndices(this.myModel.getItems(), lastSelection)).length > 0) {
            Set<String> set = lastSelection;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/DevicePicker", "getDefaultSelection"));
            }
            return set;
        }
        for (DevicePickerEntry entry : this.myModel.getItems()) {
            if (entry.isMarker()) continue;
            AndroidDevice androidDevice = entry.getAndroidDevice();
            assert (androidDevice != null) : "Non marker entry in the device picker doesn't contain an android device";
            if (this.myCompatibilityChecker.validate(androidDevice).isCompatible() == ThreeState.NO) continue;
            ImmutableSet immutableSet = ImmutableSet.of((Object)androidDevice.getSerial());
            if (immutableSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/DevicePicker", "getDefaultSelection"));
            }
            return immutableSet;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/DevicePicker", "getDefaultSelection"));
        }
        return set;
    }

    private static int getListSelectionMode(@NotNull DeviceCount deviceCount) {
        if (deviceCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceCount", "com/android/tools/idea/run/editor/DevicePicker", "getListSelectionMode"));
        }
        return deviceCount.isMultiple() ? 2 : 0;
    }

    public ValidationInfo validate() {
        List<AndroidDevice> devices = this.getSelectedDevices();
        if (devices.isEmpty()) {
            return new ValidationInfo("No device selected", (JComponent)this.myDevicesList);
        }
        for (AndroidDevice device : devices) {
            LaunchCompatibility compatibility = this.myCompatibilityChecker.validate(device);
            if (compatibility.isCompatible() != ThreeState.NO) continue;
            String reason = StringUtil.notNullize((String)compatibility.getReason(), (String)"Incompatible");
            if (devices.size() > 1) {
                reason = device.getName() + ": " + reason;
            }
            return new ValidationInfo(reason, (JComponent)this.myDevicesList);
        }
        return null;
    }

    @NotNull
    public List<AndroidDevice> getSelectedDevices() {
        SmartList devices = new SmartList();
        for (Object value : this.myDevicesList.getSelectedValues()) {
            AndroidDevice device;
            if (!(value instanceof DevicePickerEntry) || (device = ((DevicePickerEntry)value).getAndroidDevice()) == null) continue;
            devices.add((Object)device);
        }
        SmartList smartList = devices;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/DevicePicker", "getSelectedDevices"));
        }
        return smartList;
    }

    public static void launchDiagnostics(Project project) {
        BrowserUtil.browse((String)"http://developer.android.com/tools/device.html", (Project)project);
    }

    public void installDoubleClickListener(@NotNull DoubleClickListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/run/editor/DevicePicker", "installDoubleClickListener"));
        }
        listener.installOn((Component)this.myDevicesList);
    }

    private static Set<String> getLastSelectionForProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/editor/DevicePicker", "getLastSelectionForProject"));
        }
        String s = PropertiesComponent.getInstance((Project)project).getValue(DEVICE_PICKER_LAST_SELECTION);
        return s == null ? Collections.emptySet() : Sets.newHashSet((Object[])s.split(" "));
    }

    private static void saveSelectionForProject(@NotNull Project project, @NotNull Set<String> selectedSerials) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/editor/DevicePicker", "saveSelectionForProject"));
        }
        if (selectedSerials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedSerials", "com/android/tools/idea/run/editor/DevicePicker", "saveSelectionForProject"));
        }
        PropertiesComponent.getInstance((Project)project).setValue(DEVICE_PICKER_LAST_SELECTION, Joiner.on((char)' ').join(selectedSerials));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JButton jButton;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setPreferredSize(new Dimension(600, 400));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, "South");
        this.myCreateEmulatorButton = jButton = new JButton();
        jButton.setText("Create New Emulator");
        jPanel3.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myHelpHyperlink;
        jPanel3.add((Component)hyperlinkLabel, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 3, null, null, null));
        JScrollPane jScrollPane = this.myScrollPane;
        jPanel2.add((Component)jScrollPane, "Center");
        this.myNotificationPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "North");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class MyListKeyListener
    extends KeyAdapter {
        private final ListSpeedSearch mySpeedSearch;

        private MyListKeyListener(@NotNull ListSpeedSearch speedSearch) {
            if (speedSearch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "speedSearch", "com/android/tools/idea/run/editor/DevicePicker$MyListKeyListener", "<init>"));
            }
            this.mySpeedSearch = speedSearch;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.mySpeedSearch.isPopupActive()) {
                return;
            }
            JList list = (JList)e.getSource();
            int startIndex = list.getSelectedIndex();
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 40: {
                    ListScrollingUtil.moveDown((JList)list, (int)e.getModifiersEx());
                    break;
                }
                case 34: {
                    ListScrollingUtil.movePageDown((JList)list);
                    break;
                }
                case 38: {
                    ListScrollingUtil.moveUp((JList)list, (int)e.getModifiersEx());
                    break;
                }
                case 33: {
                    ListScrollingUtil.movePageUp((JList)list);
                    break;
                }
                default: {
                    return;
                }
            }
            DevicePickerEntry entry = (DevicePickerEntry)list.getSelectedValue();
            while (entry.isMarker() && list.getSelectedIndex() != startIndex) {
                if (keyCode == 38 || keyCode == 33) {
                    ListScrollingUtil.moveUp((JList)list, (int)e.getModifiersEx());
                } else {
                    ListScrollingUtil.moveDown((JList)list, (int)e.getModifiersEx());
                }
                entry = (DevicePickerEntry)list.getSelectedValue();
            }
            e.consume();
        }
    }
}

