/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunUserFeedback;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.run.tasks.DeployApkTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.util.LaunchStatus;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NoChangesTasksProvider
implements LaunchTasksProvider {
    private final AndroidFacet myFacet;

    public NoChangesTasksProvider(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/tasks/NoChangesTasksProvider", "<init>"));
        }
        this.myFacet = facet;
    }

    @Override
    @NotNull
    public List<LaunchTask> getTasks(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter consolePrinter) {
        String pkgName;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/NoChangesTasksProvider", "getTasks"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/tasks/NoChangesTasksProvider", "getTasks"));
        }
        if (consolePrinter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consolePrinter", "com/android/tools/idea/run/tasks/NoChangesTasksProvider", "getTasks"));
        }
        try {
            pkgName = ApkProviderUtil.computePackageName(this.myFacet);
        }
        catch (ApkProvisionException e) {
            launchStatus.terminateLaunch("Unable to determine application id for module " + this.myFacet.getModule().getName());
            List<LaunchTask> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/tasks/NoChangesTasksProvider", "getTasks"));
            }
            return list;
        }
        InstantRunManager.transferLocalIdToDeviceId(device, this.myFacet.getModule());
        DeployApkTask.cacheManifestInstallationData(device, this.myFacet, pkgName);
        consolePrinter.stdout("No changes.");
        new InstantRunUserFeedback(this.myFacet.getModule()).info("No changes to deploy");
        List<LaunchTask> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/tasks/NoChangesTasksProvider", "getTasks"));
        }
        return list;
    }

    @Override
    @Nullable
    public DebugConnectorTask getConnectDebuggerTask(@NotNull LaunchStatus launchStatus) {
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/tasks/NoChangesTasksProvider", "getConnectDebuggerTask"));
        }
        return null;
    }

    @Override
    public boolean createsNewProcess() {
        return false;
    }
}

