/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DevicePanel;
import com.android.tools.idea.monitor.AndroidToolWindowFactory;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowLogcatTask
implements LaunchTask {
    @NotNull
    private final Project myProject;
    @Nullable
    private final String myApplicationId;

    public ShowLogcatTask(@NotNull Project project, @Nullable String applicationId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/tasks/ShowLogcatTask", "<init>"));
        }
        this.myProject = project;
        this.myApplicationId = applicationId;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Activating Logcat Tool window" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/tasks/ShowLogcatTask", "getDescription"));
        }
        return "Activating Logcat Tool window";
    }

    @Override
    public int getDuration() {
        return 1;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/ShowLogcatTask", "perform"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/tasks/ShowLogcatTask", "perform"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/tasks/ShowLogcatTask", "perform"));
        }
        Client client = this.myApplicationId == null ? null : device.getClient(this.myApplicationId);
        ShowLogcatTask.showLogcatConsole(this.myProject, device, client);
        return true;
    }

    private static void showLogcatConsole(final @NotNull Project project, final @NotNull IDevice device, final @Nullable Client client) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/tasks/ShowLogcatTask", "showLogcatConsole"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/ShowLogcatTask", "showLogcatConsole"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                final ToolWindow androidToolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(AndroidToolWindowFactory.TOOL_WINDOW_ID);
                androidToolWindow.activate(new Runnable(){

                    @Override
                    public void run() {
                        int count = androidToolWindow.getContentManager().getContentCount();
                        for (int i = 0; i < count; ++i) {
                            DevicePanel devicePanel;
                            Content content = androidToolWindow.getContentManager().getContent(i);
                            DevicePanel devicePanel2 = devicePanel = content == null ? null : (DevicePanel)content.getUserData(AndroidToolWindowFactory.DEVICES_PANEL_KEY);
                            if (devicePanel == null) continue;
                            devicePanel.selectDevice(device);
                            devicePanel.selectClient(client);
                            break;
                        }
                    }
                }, false);
            }
        });
    }
}

