/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;

public class TextFieldWithLaunchBrowserButton
extends TextFieldWithBrowseButton {
    private static final Logger LOG = Logger.getInstance(TextFieldWithLaunchBrowserButton.class);
    private final String myUrl;

    public TextFieldWithLaunchBrowserButton(String url) {
        this.myUrl = url;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        Desktop.getDesktop().browse(URI.create(TextFieldWithLaunchBrowserButton.this.myUrl));
                    } else {
                        Messages.showErrorDialog((String)("Please visit \n" + TextFieldWithLaunchBrowserButton.this.myUrl + "\n to retrieve this value"), (String)"Could Not Open Web Browser");
                    }
                }
                catch (IOException error) {
                    LOG.error((Throwable)error);
                }
            }
        });
    }
}

